/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.room;

import jakarta.servlet.ServletContext;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.room.DefaultRoom;
import org.atmosphere.room.Room;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoomManager {
    private static final Logger logger = LoggerFactory.getLogger(RoomManager.class);
    private static final String ROOM_PREFIX = "/atmosphere/room/";
    private final BroadcasterFactory broadcasterFactory;
    private final ConcurrentMap<String, Room> rooms = new ConcurrentHashMap<String, Room>();
    private static final String CONTEXT_ATTR = RoomManager.class.getName();
    private static final ConcurrentMap<AtmosphereFramework, RoomManager> instances = new ConcurrentHashMap<AtmosphereFramework, RoomManager>();

    private RoomManager(BroadcasterFactory broadcasterFactory) {
        this.broadcasterFactory = broadcasterFactory;
    }

    public static RoomManager create(AtmosphereFramework framework) {
        return new RoomManager(framework.getBroadcasterFactory());
    }

    public static RoomManager getOrCreate(AtmosphereFramework framework) {
        return instances.computeIfAbsent(framework, fw -> {
            RoomManager rm = new RoomManager(fw.getBroadcasterFactory());
            try {
                ServletContext ctx = fw.getServletContext();
                if (ctx != null) {
                    ctx.setAttribute(CONTEXT_ATTR, (Object)rm);
                }
            }
            catch (Exception e) {
                logger.debug("Servlet context not available, storing in-memory only");
            }
            logger.info("RoomManager created for framework");
            return rm;
        });
    }

    public Room room(String name) {
        return this.rooms.computeIfAbsent(name, n -> {
            Object broadcaster = this.broadcasterFactory.lookup(ROOM_PREFIX + n, true);
            logger.info("Created room '{}'", n);
            return new DefaultRoom((String)n, (Broadcaster)broadcaster);
        });
    }

    public boolean exists(String name) {
        return this.rooms.containsKey(name);
    }

    public Collection<Room> all() {
        return Collections.unmodifiableCollection(this.rooms.values());
    }

    public int count() {
        return this.rooms.size();
    }

    public boolean destroy(String name) {
        Room room = (Room)this.rooms.remove(name);
        if (room != null) {
            room.destroy();
            return true;
        }
        return false;
    }

    public void destroyAll() {
        this.rooms.values().forEach(Room::destroy);
        this.rooms.clear();
        logger.info("All rooms destroyed");
    }
}

