/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.room;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.room.PresenceEvent;
import org.atmosphere.room.RoomMember;
import org.atmosphere.room.VirtualRoomMember;

public interface Room {
    public String name();

    public Room join(AtmosphereResource var1);

    public Room leave(AtmosphereResource var1);

    public Future<Object> broadcast(Object var1);

    public Future<Object> broadcast(Object var1, AtmosphereResource var2);

    public Future<Object> sendTo(Object var1, String var2);

    public Set<AtmosphereResource> members();

    public int size();

    public boolean isEmpty();

    public boolean contains(AtmosphereResource var1);

    public Room onPresence(Consumer<PresenceEvent> var1);

    default public Room join(AtmosphereResource resource, RoomMember member) {
        return this.join(resource);
    }

    default public Map<String, RoomMember> memberInfo() {
        return Map.of();
    }

    default public Optional<RoomMember> memberOf(AtmosphereResource resource) {
        return Optional.ofNullable(this.memberInfo().get(resource.uuid()));
    }

    default public Room joinVirtual(VirtualRoomMember member) {
        return this;
    }

    default public Room leaveVirtual(VirtualRoomMember member) {
        return this;
    }

    default public Set<VirtualRoomMember> virtualMembers() {
        return Set.of();
    }

    default public Room enableHistory(int maxMessages) {
        return this;
    }

    public void destroy();

    public boolean isDestroyed();
}

