/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.metrics;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereTracing
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereTracing.class);
    private static final AttributeKey<String> ATTR_UUID = AttributeKey.stringKey((String)"atmosphere.resource.uuid");
    private static final AttributeKey<String> ATTR_TRANSPORT = AttributeKey.stringKey((String)"atmosphere.transport");
    private static final AttributeKey<String> ATTR_ACTION = AttributeKey.stringKey((String)"atmosphere.action");
    private static final AttributeKey<String> ATTR_BROADCASTER = AttributeKey.stringKey((String)"atmosphere.broadcaster");
    private static final AttributeKey<String> ATTR_DISCONNECT_REASON = AttributeKey.stringKey((String)"atmosphere.disconnect.reason");
    private static final AttributeKey<String> ATTR_ROOM = AttributeKey.stringKey((String)"atmosphere.room");
    private static final String SPAN_KEY = AtmosphereTracing.class.getName() + ".span";
    private static final String SCOPE_KEY = AtmosphereTracing.class.getName() + ".scope";
    private final Tracer tracer;

    public AtmosphereTracing(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer("org.atmosphere", "4.0.0");
    }

    public AtmosphereTracing(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public void configure(AtmosphereConfig config) {
        logger.info("OpenTelemetry tracing enabled for Atmosphere");
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        super.inspect(r);
        String method = r.getRequest().getMethod();
        String path = r.getRequest().getPathInfo();
        if (path == null) {
            path = r.getRequest().getRequestURI();
        }
        Span span = this.tracer.spanBuilder("atmosphere " + method + " " + path).setSpanKind(SpanKind.SERVER).setAttribute(ATTR_UUID, (Object)r.uuid()).setAttribute(ATTR_TRANSPORT, (Object)r.transport().name()).startSpan();
        if (r.getBroadcaster() != null) {
            span.setAttribute(ATTR_BROADCASTER, (Object)r.getBroadcaster().getID());
        }
        Scope scope = span.makeCurrent();
        r.getRequest().setAttribute(SPAN_KEY, span);
        r.getRequest().setAttribute(SCOPE_KEY, scope);
        r.addEventListener(new TracingResourceListener(span));
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
        Span span = (Span)r.getRequest().getAttribute(SPAN_KEY);
        if (span != null) {
            String action = r.getAtmosphereResourceEvent() != null && r.getAtmosphereResourceEvent().isSuspended() ? "SUSPEND" : "CONTINUE";
            span.setAttribute(ATTR_ACTION, (Object)action);
            if (!"SUSPEND".equals(action)) {
                this.endSpan(r);
            }
        }
    }

    private void endSpan(AtmosphereResource r) {
        Scope scope = (Scope)r.getRequest().getAttribute(SCOPE_KEY);
        Span span = (Span)r.getRequest().getAttribute(SPAN_KEY);
        if (scope != null) {
            scope.close();
            r.getRequest().removeAttribute(SCOPE_KEY);
        }
        if (span != null) {
            span.end();
            r.getRequest().removeAttribute(SPAN_KEY);
        }
    }

    public Span startRoomSpan(String operation, String roomName, String uuid) {
        return this.tracer.spanBuilder("atmosphere.room." + operation).setSpanKind(SpanKind.INTERNAL).setAttribute(ATTR_ROOM, (Object)roomName).setAttribute(ATTR_UUID, (Object)uuid).startSpan();
    }

    @Override
    public String toString() {
        return "AtmosphereTracing{opentelemetry}";
    }

    private static class TracingResourceListener
    extends AtmosphereResourceEventListenerAdapter {
        private final Span span;

        TracingResourceListener(Span span) {
            this.span = span;
        }

        @Override
        public void onSuspend(AtmosphereResourceEvent event) {
            this.span.addEvent("atmosphere.suspend");
        }

        @Override
        public void onResume(AtmosphereResourceEvent event) {
            this.span.addEvent("atmosphere.resume");
            if (event.isResumedOnTimeout()) {
                this.span.setAttribute(ATTR_DISCONNECT_REASON, (Object)"timeout");
            }
            this.endIfActive();
        }

        @Override
        public void onBroadcast(AtmosphereResourceEvent event) {
            this.span.addEvent("atmosphere.broadcast", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"atmosphere.message.type"), (Object)(event.getMessage() != null ? event.getMessage().getClass().getSimpleName() : "null")));
        }

        @Override
        public void onDisconnect(AtmosphereResourceEvent event) {
            String reason = event.isClosedByClient() ? "client" : "application";
            this.span.setAttribute(ATTR_DISCONNECT_REASON, (Object)reason);
            this.span.addEvent("atmosphere.disconnect");
            this.endIfActive();
        }

        @Override
        public void onClose(AtmosphereResourceEvent event) {
            this.span.addEvent("atmosphere.close");
            this.endIfActive();
        }

        @Override
        public void onThrowable(AtmosphereResourceEvent event) {
            Throwable t = event.throwable();
            if (t != null) {
                this.span.recordException(t);
                this.span.setStatus(StatusCode.ERROR, t.getMessage());
            }
            this.endIfActive();
        }

        private void endIfActive() {
            this.span.end();
        }
    }
}

