/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDisconnectInterceptor
extends AtmosphereInterceptorAdapter {
    private final Logger logger = LoggerFactory.getLogger(OnDisconnectInterceptor.class);
    private AtmosphereConfig config;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        AtmosphereRequest request = ((AtmosphereResourceImpl)r).getRequest(false);
        String uuid = r.uuid();
        if (Utils.closeMessage(request)) {
            if (this.config.resourcesFactory() == null || uuid == null) {
                this.logger.debug("Illegal state for uuid {} and AtmosphereResourceFactory {}", (Object)r.uuid(), (Object)this.config.resourcesFactory());
                return Action.CANCELLED;
            }
            AtmosphereResource ss = this.config.resourcesFactory().findResource(uuid).orElseGet(() -> {
                this.logger.debug("No Suspended Connection found for {}. Using the AtmosphereResource associated with the close message", (Object)uuid);
                return r;
            });
            this.logger.debug("AtmosphereResource {} disconnected", (Object)uuid);
            ((AtmosphereResourceEventImpl)ss.getAtmosphereResourceEvent()).isClosedByClient(true);
            AsyncSupport<?> asyncSupport = this.config.framework().getAsyncSupport();
            if (asyncSupport instanceof AsynchronousProcessor) {
                AsynchronousProcessor asyncProcessor = (AsynchronousProcessor)asyncSupport;
                asyncProcessor.completeLifecycle(ss, false);
            }
            return Action.CANCELLED;
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "Browser disconnection detection";
    }
}

