/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OnMessage<T>
extends AbstractReflectorAtmosphereHandler {
    private final Logger logger = LoggerFactory.getLogger(OnMessage.class);

    @Override
    public final void onRequest(AtmosphereResource resource) throws IOException {
        if (resource.getRequest().getMethod().equalsIgnoreCase("GET")) {
            this.onOpen(resource);
        }
    }

    @Override
    public final void onStateChange(AtmosphereResourceEvent event) throws IOException {
        AtmosphereResponse response = ((AtmosphereResourceImpl)event.getResource()).getResponse(false);
        this.logger.trace("{} with event {}", (Object)event.getResource().uuid(), (Object)event);
        if (event.isCancelled() || event.isClosedByApplication() || event.isClosedByClient()) {
            this.onDisconnect(response);
        } else {
            Iterator iterator = event.getMessage();
            if (iterator instanceof List) {
                List messages = (List)((Object)iterator);
                for (Object item : messages) {
                    this.onMessage(response, item);
                }
            } else if (event.isResuming()) {
                this.onResume(response);
            } else if (event.isResumedOnTimeout()) {
                this.onTimeout(response);
            } else if (event.isSuspended()) {
                this.onMessage(response, event.getMessage());
            }
        }
        this.postStateChange(event);
    }

    @Override
    public final void destroy() {
    }

    public void onOpen(AtmosphereResource resource) throws IOException {
    }

    public abstract void onMessage(AtmosphereResponse var1, T var2) throws IOException;

    public void onResume(AtmosphereResponse response) throws IOException {
    }

    public void onTimeout(AtmosphereResponse response) throws IOException {
    }

    public void onDisconnect(AtmosphereResponse response) throws IOException {
    }
}

