/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereHandlerWrapper;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.InterceptorRegistry;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.util.DefaultEndpointMapper;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(HandlerRegistry.class);
    private final AtmosphereConfig config;
    private final InterceptorRegistry interceptorRegistry;
    private final Map<String, AtmosphereHandlerWrapper> atmosphereHandlers = new ConcurrentHashMap<String, AtmosphereHandlerWrapper>();
    private EndpointMapper<AtmosphereHandlerWrapper> endpointMapper = new DefaultEndpointMapper<AtmosphereHandlerWrapper>();
    private String mappingRegex = "[a-zA-Z0-9-&.*_~=@;\\?]+";
    private Supplier<BroadcasterFactory> broadcasterFactorySupplier;

    public HandlerRegistry(AtmosphereConfig config, InterceptorRegistry interceptorRegistry) {
        this.config = config;
        this.interceptorRegistry = interceptorRegistry;
    }

    void setBroadcasterFactorySupplier(Supplier<BroadcasterFactory> supplier) {
        this.broadcasterFactorySupplier = supplier;
    }

    public Map<String, AtmosphereHandlerWrapper> handlers() {
        return this.atmosphereHandlers;
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h, List<AtmosphereInterceptor> l) {
        if (!((String)mapping).startsWith("/")) {
            mapping = "/" + (String)mapping;
        }
        this.createWrapperAndConfigureHandler(h, (String)mapping, l);
        if (!this.config.framework().isInit) {
            logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), mapping);
            logger.info("Installed the following AtmosphereInterceptor mapped to AtmosphereHandler {}", (Object)h.getClass().getName());
            if (!l.isEmpty()) {
                for (AtmosphereInterceptor s : l) {
                    logger.info("\t{} : {}", (Object)s.getClass().getName(), (Object)s);
                }
            }
        }
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster, List<AtmosphereInterceptor> l) {
        if (!((String)mapping).startsWith("/")) {
            mapping = "/" + (String)mapping;
        }
        this.createWrapperAndConfigureHandler(h, (String)mapping, l).setBroadcaster(broadcaster);
        if (!this.config.framework().isInit) {
            logger.info("Installed AtmosphereHandler {} mapped to context-path {} and Broadcaster Class {}", new Object[]{h.getClass().getName(), mapping, broadcaster.getClass().getName()});
        } else {
            logger.debug("Installed AtmosphereHandler {} mapped to context-path {} and Broadcaster Class {}", new Object[]{h.getClass().getName(), mapping, broadcaster.getClass().getName()});
        }
        if (!l.isEmpty()) {
            logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)h.getClass().getName());
        }
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId, List<AtmosphereInterceptor> l) {
        if (!((String)mapping).startsWith("/")) {
            mapping = "/" + (String)mapping;
        }
        this.createWrapperAndConfigureHandler(h, (String)mapping, l).broadcaster().setID(broadcasterId);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), mapping);
        if (!l.isEmpty()) {
            logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)h.getClass().getName());
        }
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        this.addAtmosphereHandler(mapping, h, List.of());
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId) {
        this.addAtmosphereHandler(mapping, h, broadcasterId, List.of());
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster) {
        this.addAtmosphereHandler(mapping, h, broadcaster, List.of());
    }

    protected AtmosphereHandlerWrapper createWrapperAndConfigureHandler(AtmosphereHandler h, String mapping, List<AtmosphereInterceptor> l) {
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(this.broadcasterFactorySupplier.get(), h, mapping, this.config);
        this.addMapping(mapping, w);
        this.interceptorRegistry.addInterceptorToWrapper(w, l);
        this.initServletProcessor(h);
        return w;
    }

    private void addMapping(String path, AtmosphereHandlerWrapper w) {
        this.atmosphereHandlers.put(this.normalizePath(path), w);
    }

    public String normalizePath(String path) {
        if (((String)path).contains("*")) {
            path = ((String)path).replace("*", this.mappingRegex);
        }
        if (((String)path).endsWith("/")) {
            path = (String)path + this.mappingRegex;
        }
        return path;
    }

    private void initServletProcessor(AtmosphereHandler h) {
        if (!this.config.framework().isInit) {
            return;
        }
        try {
            if (h instanceof AtmosphereServletProcessor) {
                AtmosphereServletProcessor asp = (AtmosphereServletProcessor)h;
                asp.init(this.config);
            }
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAtmosphereHandler(String mapping) {
        if (((String)mapping).endsWith("/")) {
            mapping = (String)mapping + this.mappingRegex;
        }
        this.atmosphereHandlers.remove(mapping);
    }

    public void removeAllAtmosphereHandler() {
        this.atmosphereHandlers.clear();
    }

    public void addWebSocketHandler(WebSocketHandler handler) {
        this.addWebSocketHandler("/*", handler);
    }

    public void addWebSocketHandler(String path, WebSocketHandler handler) {
        this.addWebSocketHandler(path, handler, AtmosphereFramework.REFLECTOR_ATMOSPHEREHANDLER, List.of());
    }

    public void addWebSocketHandler(String path, WebSocketHandler handler, AtmosphereHandler h) {
        this.addWebSocketHandler(path, handler, AtmosphereFramework.REFLECTOR_ATMOSPHEREHANDLER, List.of());
    }

    public void addWebSocketHandler(String path, WebSocketHandler handler, AtmosphereHandler h, List<AtmosphereInterceptor> l) {
        WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.config.framework()).registerWebSocketHandler(path, new WebSocketProcessor.WebSocketHandlerProxy(this.broadcasterFactorySupplier.get().lookup(path, true).getClass(), handler));
        this.addAtmosphereHandler(path, h, l);
    }

    public void initAtmosphereHandler() throws ServletException {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper w = h.getValue();
            AtmosphereHandler a = w.atmosphereHandler();
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            AtmosphereServletProcessor asp = (AtmosphereServletProcessor)a;
            asp.init(this.config);
        }
        this.checkWebSocketSupportState();
    }

    public void checkWebSocketSupportState() {
        if (this.atmosphereHandlers.isEmpty() && !(this.config.framework().webSocket().getProtocol() instanceof SimpleHttpProtocol)) {
            logger.debug("Adding a void AtmosphereHandler mapped to /* to allow WebSocket application only");
            this.addAtmosphereHandler("/*", new AbstractReflectorAtmosphereHandler(this){

                @Override
                public void onRequest(AtmosphereResource r) throws IOException {
                    logger.debug("No AtmosphereHandler defined.");
                    if (!r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
                        WebSocket.notSupported(r.getRequest(), r.getResponse());
                    }
                }

                @Override
                public void destroy() {
                }
            });
        }
    }

    public void initEndpointMapper() {
        AtmosphereFramework fw = this.config.framework();
        String s = fw.getServletConfig().getInitParameter("org.atmosphere.cpr.EndpointMapper");
        if (s != null) {
            try {
                this.endpointMapper = fw.newClassInstance(EndpointMapper.class, IOUtils.loadClass(fw.getClass(), s));
                logger.info("Installed EndpointMapper {} ", (Object)s);
            }
            catch (Exception ex) {
                logger.error("Cannot load the EndpointMapper {}", (Object)s, (Object)ex);
            }
        }
        this.endpointMapper.configure(this.config);
    }

    public void configureWebDotXmlAtmosphereHandler(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereHandler");
        if (s != null) {
            try {
                AtmosphereFramework fw = this.config.framework();
                String mapping = sc.getInitParameter("org.atmosphere.cpr.AtmosphereHandler.contextRoot");
                if (mapping == null) {
                    mapping = "/*";
                }
                this.addAtmosphereHandler(mapping, fw.newClassInstance(AtmosphereHandler.class, IOUtils.loadClass(fw.getClass(), s)));
            }
            catch (Exception ex) {
                logger.warn("Unable to load WebSocketHandle instance", (Throwable)ex);
            }
        }
    }

    public EndpointMapper<AtmosphereHandlerWrapper> endPointMapper() {
        return this.endpointMapper;
    }

    public void endPointMapper(EndpointMapper<?> endpointMapper) {
        this.endpointMapper = endpointMapper;
    }

    public String mappingRegex() {
        return this.mappingRegex;
    }

    public void mappingRegex(String mappingRegex) {
        this.mappingRegex = mappingRegex;
    }

    public void clear() {
        this.atmosphereHandlers.clear();
    }
}

