/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.ArrayList;
import java.util.List;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.JSR356AsyncSupport;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsyncSupportResolver;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncSupportResolver
implements AsyncSupportResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAsyncSupportResolver.class);
    public static final String SERVLET_30 = "jakarta.servlet.AsyncListener";
    public static final String JSR356_WEBSOCKET = "jakarta.websocket.Endpoint";
    private final AtmosphereConfig config;
    private final boolean suppress356;

    public DefaultAsyncSupportResolver(AtmosphereConfig config) {
        this.config = config;
        this.suppress356 = Boolean.parseBoolean(config.getInitParameter("org.atmosphere.websocket.suppressJSR356"));
    }

    protected boolean testClassExists(String testClass) {
        try {
            boolean exists = testClass != null && testClass.length() > 0 && IOUtils.loadClass(null, testClass) != null;
            logger.debug(exists ? "Found {}" : "Not found {}", (Object)testClass);
            return exists;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List<Class<? extends AsyncSupport<?>>> detectContainersPresent() {
        return new ArrayList();
    }

    public List<Class<? extends AsyncSupport<?>>> detectWebSocketPresent(boolean useNativeIfPossible, boolean useServlet30Async) {
        ArrayList result = new ArrayList();
        if (useServlet30Async && !useNativeIfPossible) {
            if (!this.suppress356 && this.testClassExists(JSR356_WEBSOCKET)) {
                result.add(JSR356AsyncSupport.class);
            }
        } else if (!this.suppress356 && this.testClassExists(JSR356_WEBSOCKET)) {
            result.add(JSR356AsyncSupport.class);
        }
        return result;
    }

    public AsyncSupport<?> defaultCometSupport(boolean preferBlocking) {
        if (!preferBlocking && this.testClassExists(SERVLET_30)) {
            return new Servlet30CometSupport(this.config);
        }
        return new BlockingIOCometSupport(this.config);
    }

    public AsyncSupport<?> newCometSupport(Class<? extends AsyncSupport<?>> targetClass) {
        try {
            return targetClass.getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.warn("Failed to create AsyncSupport class: {}, error: {}", targetClass, (Object)e);
            Throwable cause = e.getCause();
            if (cause != null) {
                logger.error("Real error: {}", (Object)cause.getMessage(), (Object)cause);
            }
            return null;
        }
    }

    public AsyncSupport<?> newCometSupport(String targetClassFQN) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return (AsyncSupport)cl.loadClass(targetClassFQN).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.error("Failed to create AsyncSupport class: {}, error: {}", (Object)targetClassFQN, (Object)e);
            Throwable cause = e.getCause();
            if (cause != null) {
                logger.error("Real error: {}", (Object)cause.getMessage(), (Object)cause);
            }
            throw new IllegalArgumentException("Unable to create " + targetClassFQN, e);
        }
    }

    public AsyncSupport<?> resolve(boolean useNativeIfPossible, boolean defaultToBlocking) {
        AsyncSupport<?> servletAsyncSupport = this.defaultCometSupport(defaultToBlocking);
        if (!defaultToBlocking && (useNativeIfPossible || servletAsyncSupport.getClass().getName().equals(BlockingIOCometSupport.class.getName()))) {
            AsyncSupport<?> nativeSupport = this.resolveNativeCometSupport(this.detectContainersPresent());
            return nativeSupport == null ? servletAsyncSupport : nativeSupport;
        }
        return servletAsyncSupport;
    }

    @Override
    public AsyncSupport<?> resolve(boolean useNativeIfPossible, boolean defaultToBlocking, boolean useServlet30Async) {
        List<Class<AsyncSupport<?>>> l;
        AsyncSupport<?> cs = null;
        useServlet30Async = this.testClassExists(SERVLET_30);
        if (!defaultToBlocking && !(l = this.detectWebSocketPresent(useNativeIfPossible, useServlet30Async)).isEmpty()) {
            cs = this.resolveWebSocket(l);
        }
        if (cs == null) {
            AsyncSupport<?> nativeSupport = this.resolveNativeCometSupport(this.detectContainersPresent());
            return nativeSupport == null ? this.defaultCometSupport(defaultToBlocking) : nativeSupport;
        }
        return cs;
    }

    public AsyncSupport<?> resolveWebSocket(List<Class<? extends AsyncSupport<?>>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        return this.newCometSupport(available.get(0));
    }

    protected AsyncSupport<?> resolveNativeCometSupport(List<Class<? extends AsyncSupport<?>>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        if (available.size() == 1) {
            return this.newCometSupport(available.get(0));
        }
        return this.resolveMultipleNativeSupportConflict(available);
    }

    protected AsyncSupport<?> resolveMultipleNativeSupportConflict(List<Class<? extends AsyncSupport<?>>> available) {
        StringBuilder b = new StringBuilder("Found multiple containers, please specify which one to use: ");
        for (Class<AsyncSupport<?>> cs : available) {
            b.append(cs != null ? cs.getCanonicalName() : "null").append(", ");
        }
        b.append(" until you do, Atmosphere will use:").append(available.get(0));
        logger.warn("{}", (Object)b.toString());
        return this.newCometSupport(available.get(0));
    }
}

