/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import jakarta.inject.Named;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.atmosphere.config.managed.ServiceInterceptor;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.Singleton;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereHandlerWrapper;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtmosphereHandlerServiceInterceptor
extends ServiceInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereHandlerServiceInterceptor.class);
    private final ReentrantLock handlersLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mapAnnotatedService(boolean reMap, String path, AtmosphereRequest request, AtmosphereHandlerWrapper w) {
        block7: {
            this.handlersLock.lock();
            try {
                AtmosphereHandlerService m;
                if (this.config.handlers().get(path) != null || (m = w.atmosphereHandler().getClass().getAnnotation(AtmosphereHandlerService.class)) == null) break block7;
                try {
                    String targetPath = m.path();
                    if (targetPath.contains("{") && targetPath.contains("}")) {
                        boolean singleton = w.atmosphereHandler().getClass().getAnnotation(Singleton.class) != null;
                        AtmosphereHandler newW = w.atmosphereHandler();
                        if (!singleton) {
                            newW = this.config.framework().newClassInstance(AtmosphereHandler.class, w.atmosphereHandler().getClass());
                        }
                        request.localAttributes().put(Named.class.getName(), path.substring(targetPath.indexOf("{")));
                        ((AtmosphereResourceImpl)request.resource()).atmosphereHandler(newW);
                        this.config.framework().addAtmosphereHandler(path, newW, (Broadcaster)this.config.getBroadcasterFactory().lookup(w.broadcaster().getClass(), path, true), (List<AtmosphereInterceptor>)w.interceptors());
                        request.setAttribute(FrameworkConfig.NEW_MAPPING, "true");
                    }
                }
                catch (Throwable e) {
                    logger.warn("Unable to create AtmosphereHandler", e);
                }
            }
            finally {
                this.handlersLock.unlock();
            }
        }
    }

    @Override
    public String toString() {
        return "@AtmosphereHandlerService Interceptor";
    }
}

