/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.TimeUnit;

public class BroadcasterLifeCyclePolicy {
    public static final BroadcasterLifeCyclePolicy IDLE = new BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY.IDLE);
    public static final BroadcasterLifeCyclePolicy IDLE_DESTROY = new BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY);
    public static final BroadcasterLifeCyclePolicy IDLE_RESUME = new BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY.IDLE_RESUME);
    public static final BroadcasterLifeCyclePolicy EMPTY = new BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY.EMPTY);
    public static final BroadcasterLifeCyclePolicy EMPTY_DESTROY = new BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY);
    public static final BroadcasterLifeCyclePolicy IDLE_EMPTY_DESTROY = new BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY.IDLE_EMPTY_DESTROY);
    public static final BroadcasterLifeCyclePolicy NEVER = new BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY.NEVER);
    private final ATMOSPHERE_RESOURCE_POLICY policy;
    private final int time;
    private final TimeUnit timeUnit;

    private BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY policy, int time, TimeUnit timeUnit) {
        this.policy = policy;
        this.time = time;
        this.timeUnit = timeUnit;
    }

    private BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY policy) {
        this.policy = policy;
        this.time = -1;
        this.timeUnit = null;
    }

    public ATMOSPHERE_RESOURCE_POLICY getLifeCyclePolicy() {
        return this.policy;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int getTimeout() {
        return this.time;
    }

    public static enum ATMOSPHERE_RESOURCE_POLICY {
        IDLE,
        IDLE_DESTROY,
        IDLE_RESUME,
        EMPTY,
        EMPTY_DESTROY,
        IDLE_EMPTY_DESTROY,
        NEVER;

    }

    public static final class Builder {
        private ATMOSPHERE_RESOURCE_POLICY policy;
        private int time;
        private TimeUnit timeUnit;

        public Builder policy(ATMOSPHERE_RESOURCE_POLICY policy) {
            this.policy = policy;
            return this;
        }

        public Builder idleTimeInMS(int time) {
            this.timeUnit = TimeUnit.MILLISECONDS;
            this.time = time;
            return this;
        }

        public Builder idleTime(int time, TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            this.time = time;
            return this;
        }

        public BroadcasterLifeCyclePolicy build() {
            return new BroadcasterLifeCyclePolicy(this.policy, this.time, this.timeUnit);
        }
    }
}

