/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingIOCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BlockingIOCometSupport.class);
    protected static final String LATCH = BlockingIOCometSupport.class.getName() + ".latch";
    public static final String DEFAULT_SUSPEND_TIMEOUT_PARAM = "org.atmosphere.container.blockingIO.defaultTimeout";
    public static final String JDK25_SAFE_MODE_PARAM = "org.atmosphere.container.blockingIO.jdk25SafeMode";
    private static final long DEFAULT_TIMEOUT_MS = 10000L;
    private static final boolean IS_JDK25_OR_LATER;
    private final long defaultTimeout;
    private final boolean jdk25SafeMode;

    public BlockingIOCometSupport(AtmosphereConfig config) {
        super(config);
        long configuredTimeout = 10000L;
        String timeoutParam = config.getInitParameter(DEFAULT_SUSPEND_TIMEOUT_PARAM);
        if (timeoutParam != null) {
            try {
                configuredTimeout = Long.parseLong(timeoutParam);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid {} value: '{}', using default {}ms", new Object[]{DEFAULT_SUSPEND_TIMEOUT_PARAM, timeoutParam, 10000L});
                configuredTimeout = 10000L;
            }
        }
        this.defaultTimeout = configuredTimeout;
        boolean safeModeEnabled = IS_JDK25_OR_LATER;
        String safeModeParam = config.getInitParameter(JDK25_SAFE_MODE_PARAM);
        if (safeModeParam != null) {
            safeModeEnabled = Boolean.parseBoolean(safeModeParam);
            logger.info("BlockingIOCometSupport JDK25 safe mode explicitly {} (timeout={}ms)", (Object)(safeModeEnabled ? "enabled" : "disabled"), (Object)this.defaultTimeout);
        } else if (IS_JDK25_OR_LATER) {
            logger.info("BlockingIOCometSupport JDK25 safe mode auto-enabled (JDK {}, timeout={}ms)", (Object)Runtime.version().feature(), (Object)this.defaultTimeout);
        }
        this.jdk25SafeMode = safeModeEnabled;
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = this.suspended(req, res);
        if (action.type() == Action.TYPE.SUSPEND) {
            this.suspend(action, req, res);
        } else if (action.type() == Action.TYPE.RESUME) {
            CountDownLatch latch = (CountDownLatch)req.getAttribute(LATCH);
            if (latch == null || req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
                logger.debug("response wasn't suspended: {}", (Object)res);
                return action;
            }
            latch.countDown();
            Action nextAction = this.resumed(req, res);
            if (nextAction.type() == Action.TYPE.SUSPEND) {
                this.suspend(action, req, res);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(Action action, AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        final CountDownLatch latch = new CountDownLatch(1);
        req.setAttribute(LATCH, latch);
        boolean ok = true;
        AtmosphereResource resource = req.resource();
        if (resource != null) {
            try {
                resource.addEventListener(new AtmosphereResourceEventListenerAdapter.OnResume(this){
                    final /* synthetic */ BlockingIOCometSupport this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void onResume(AtmosphereResourceEvent event) {
                        latch.countDown();
                    }
                });
                if (action.timeout() != -1L) {
                    ok = latch.await(action.timeout(), TimeUnit.MILLISECONDS);
                } else if (this.jdk25SafeMode && this.defaultTimeout > 0L) {
                    ok = latch.await(this.defaultTimeout, TimeUnit.MILLISECONDS);
                    if (!ok) {
                        logger.debug("BlockingIOCometSupport timed out after {}ms (JDK25 safe mode)", (Object)this.defaultTimeout);
                    }
                } else {
                    latch.await();
                }
            }
            catch (InterruptedException ex) {
                logger.trace("", (Throwable)ex);
            }
            finally {
                if (!ok) {
                    this.timedout(req, res);
                } else {
                    ((AtmosphereResourceImpl)resource).cancel();
                }
            }
        }
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action a = super.cancelled(req, res);
        if (req.getAttribute(LATCH) != null) {
            CountDownLatch latch = (CountDownLatch)req.getAttribute(LATCH);
            latch.countDown();
        }
        return a;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        try {
            super.action(r);
            if (r.action().type() == Action.TYPE.RESUME) {
                this.complete(r);
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    @Override
    public AsyncSupport<AtmosphereResourceImpl> complete(AtmosphereResourceImpl r) {
        AtmosphereRequest req = r.getRequest(false);
        CountDownLatch latch = null;
        if (req.getAttribute(LATCH) != null) {
            latch = (CountDownLatch)req.getAttribute(LATCH);
        }
        if (latch != null) {
            latch.countDown();
        } else if (req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
            logger.trace("Unable to resume the suspended connection");
        }
        return this;
    }

    static {
        int javaVersion = Runtime.version().feature();
        IS_JDK25_OR_LATER = javaVersion >= 25;
    }
}

