/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.Universe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSupport
implements HttpSessionListener {
    private final Logger logger = LoggerFactory.getLogger(SessionSupport.class);
    static boolean initializationHint;

    public SessionSupport() {
        initializationHint = true;
    }

    public void sessionCreated(HttpSessionEvent se) {
        this.logger.trace("Session created");
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.logger.trace("Session destroyed");
        try {
            HttpSession s = se.getSession();
            BroadcasterFactory f = Universe.broadcasterFactory();
            if (f != null) {
                for (Broadcaster b : f.lookupAll()) {
                    for (AtmosphereResource r : b.getAtmosphereResources()) {
                        if (r.session(false) == null || !r.session().getId().equals(s.getId())) continue;
                        ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).session(null);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("", t);
        }
    }
}

