/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.runtime;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.runtime.AtmosphereFramework;
import org.atmosphere.runtime.AtmosphereFrameworkInitializer;
import org.atmosphere.runtime.AtmosphereRequestImpl;
import org.atmosphere.runtime.AtmosphereResponseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereServlet
extends HttpServlet {
    private static final long serialVersionUID = 7526472295622776146L;
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    protected final AtmosphereFrameworkInitializer initializer;

    public AtmosphereServlet() {
        this(false);
    }

    public AtmosphereServlet(boolean isFilter) {
        this(isFilter, true);
    }

    public AtmosphereServlet(boolean isFilter, boolean autoDetectHandlers) {
        this.initializer = new AtmosphereFrameworkInitializer(isFilter, autoDetectHandlers);
    }

    public void destroy() {
        this.initializer.destroy();
    }

    public void init(ServletConfig sc) throws ServletException {
        this.configureFramework(sc);
        super.init(sc);
    }

    protected AtmosphereServlet configureFramework(ServletConfig sc) throws ServletException {
        return this.configureFramework(sc, true);
    }

    protected AtmosphereServlet configureFramework(ServletConfig sc, boolean init) throws ServletException {
        this.initializer.configureFramework(sc, init, false, AtmosphereFramework.class);
        return this;
    }

    protected AtmosphereFramework newAtmosphereFramework() {
        return this.initializer.newAtmosphereFramework(AtmosphereFramework.class);
    }

    public AtmosphereFramework framework() {
        return this.initializer.framework();
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.framework().doCometSupport(AtmosphereRequestImpl.wrap(req), AtmosphereResponseImpl.wrap(res));
    }
}

