/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.runtime;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.AtmosphereResourceImpl;
import org.atmosphere.runtime.Broadcaster;
import org.atmosphere.runtime.BroadcasterFactory;
import org.atmosphere.runtime.FrameworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSupport
implements HttpSessionListener {
    private final Logger logger = LoggerFactory.getLogger(SessionSupport.class);
    public static boolean initializationHint;

    public SessionSupport() {
        initializationHint = true;
    }

    public void sessionCreated(HttpSessionEvent se) {
        this.logger.trace("Session created");
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.logger.trace("Session destroyed");
        try {
            HttpSession s = se.getSession();
            BroadcasterFactory f = (BroadcasterFactory)s.getAttribute(FrameworkConfig.BROADCASTER_FACTORY);
            if (f != null) {
                s.setAttribute(FrameworkConfig.BROADCASTER_FACTORY, null);
                for (Broadcaster b : f.lookupAll()) {
                    for (AtmosphereResource r : b.getAtmosphereResources()) {
                        if (r.session(false) == null || !r.session().getId().equals(s.getId())) continue;
                        ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).session(null);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("", t);
        }
    }
}

