/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.runtime;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.atmosphere.config.AtmosphereHandlerConfig;
import org.atmosphere.runtime.AtmosphereFramework;
import org.atmosphere.runtime.AtmosphereResourceFactory;
import org.atmosphere.runtime.AtmosphereResourceSessionFactory;
import org.atmosphere.runtime.BroadcasterFactory;
import org.atmosphere.runtime.MetaBroadcaster;
import org.atmosphere.util.UUIDProvider;
import org.atmosphere.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereConfig {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereConfig.class);
    private List<AtmosphereHandlerConfig> atmosphereHandlerConfig = new ArrayList<AtmosphereHandlerConfig>();
    private boolean supportSession;
    private boolean sessionTimeoutRemovalAllowed;
    private boolean throwExceptionOnCloned;
    private AtmosphereFramework framework;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    protected List<ShutdownHook> shutdownHooks = new ArrayList<ShutdownHook>();
    protected List<StartupHook> startUpHook = new ArrayList<StartupHook>();

    protected AtmosphereConfig(AtmosphereFramework framework) {
        this.framework = framework;
    }

    public List<AtmosphereHandlerConfig> getAtmosphereHandlerConfig() {
        return this.atmosphereHandlerConfig;
    }

    public AtmosphereFramework framework() {
        return this.framework;
    }

    public ServletConfig getServletConfig() {
        return this.framework.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.framework.getServletContext();
    }

    public String getWebServerName() {
        return this.framework.getAsyncSupport().getContainerName();
    }

    public Map<String, AtmosphereFramework.AtmosphereHandlerWrapper> handlers() {
        return this.framework.getAtmosphereHandlers();
    }

    public String getInitParameter(String name) {
        try {
            return this.framework.getServletConfig().getInitParameter(name);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public Enumeration<String> getInitParameterNames() {
        return this.framework().getServletConfig().getInitParameterNames();
    }

    public boolean isSupportSession() {
        return this.supportSession;
    }

    public void setSupportSession(boolean supportSession) {
        this.supportSession = supportSession;
    }

    public boolean isSessionTimeoutRemovalAllowed() {
        return this.sessionTimeoutRemovalAllowed;
    }

    public void setSessionTimeoutRemovalAllowed(boolean sessionTimeoutRemovalAllowed) {
        this.sessionTimeoutRemovalAllowed = sessionTimeoutRemovalAllowed;
    }

    public boolean isThrowExceptionOnCloned() {
        return this.throwExceptionOnCloned;
    }

    public void setThrowExceptionOnCloned(boolean throwExceptionOnCloned) {
        this.throwExceptionOnCloned = throwExceptionOnCloned;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        return this.framework.getBroadcasterFactory();
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    protected void destroy() {
        for (ShutdownHook h : this.shutdownHooks) {
            try {
                h.shutdown();
            }
            catch (Exception ex) {
                logger.warn("", (Throwable)ex);
            }
        }
        this.properties.clear();
        this.shutdownHooks.clear();
        this.startUpHook.clear();
        this.atmosphereHandlerConfig.clear();
    }

    protected void initComplete() {
        for (StartupHook h : this.startUpHook) {
            try {
                h.started(this.framework);
            }
            catch (Exception ex) {
                logger.warn("", (Throwable)ex);
            }
        }
        this.startUpHook.clear();
    }

    public AtmosphereConfig shutdownHook(ShutdownHook s) {
        this.shutdownHooks.add(s);
        return this;
    }

    public AtmosphereConfig startupHook(StartupHook s) {
        if (this.framework().isInit) {
            s.started(this.framework);
        } else {
            this.startUpHook.add(s);
        }
        return this;
    }

    public String getInitParameter(String key, String defaultValue) {
        String s = this.getInitParameter(key);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public boolean getInitParameter(String key, boolean defaultValue) {
        String s = this.getInitParameter(key);
        if (s == null) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public int getInitParameter(String key, int defaultValue) {
        String s = this.getInitParameter(key);
        if (s == null) {
            return defaultValue;
        }
        return Integer.valueOf(s);
    }

    public AtmosphereResourceFactory resourcesFactory() {
        return this.framework.atmosphereFactory();
    }

    public MetaBroadcaster metaBroadcaster() {
        return this.framework.metaBroadcaster();
    }

    public AtmosphereResourceSessionFactory sessionFactory() {
        return this.framework.sessionFactory();
    }

    public UUIDProvider uuidProvider() {
        return this.framework.uuidProvider();
    }

    public WebSocketFactory websocketFactory() {
        return this.framework.webSocketFactory();
    }

    public AtmosphereConfig populate(AtmosphereConfig config) {
        this.atmosphereHandlerConfig = config.atmosphereHandlerConfig;
        this.supportSession = config.supportSession;
        this.sessionTimeoutRemovalAllowed = config.sessionTimeoutRemovalAllowed;
        this.throwExceptionOnCloned = config.throwExceptionOnCloned;
        this.framework = config.framework;
        this.properties.putAll(config.properties);
        this.shutdownHooks = config.shutdownHooks;
        this.startUpHook = config.startUpHook;
        return this;
    }

    public static interface StartupHook {
        public void started(AtmosphereFramework var1);
    }

    public static interface ShutdownHook {
        public void shutdown();
    }
}

