/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.runtime.Action;
import org.atmosphere.runtime.AtmosphereConfig;
import org.atmosphere.runtime.AtmosphereInterceptorAdapter;
import org.atmosphere.runtime.AtmosphereRequest;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.AtmosphereResponse;
import org.atmosphere.runtime.FrameworkConfig;
import org.atmosphere.util.Utils;

public class CacheHeadersInterceptor
extends AtmosphereInterceptorAdapter {
    private boolean injectCacheHeaders;
    private boolean writeHeaders;

    @Override
    public void configure(AtmosphereConfig config) {
        String nocache = config.getInitParameter("org.atmosphere.runtime.noCacheHeaders");
        this.injectCacheHeaders = nocache == null;
        String wh = config.getInitParameter(FrameworkConfig.WRITE_HEADERS);
        this.writeHeaders = wh != null ? Boolean.parseBoolean(wh) : true;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        AtmosphereResponse response = r.getResponse();
        AtmosphereRequest request = r.getRequest();
        request.setAttribute("org.atmosphere.runtime.noCacheHeaders", this.injectCacheHeaders);
        if (this.writeHeaders && this.injectCacheHeaders) {
            response.setHeader("Expires", "-1");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.setHeader("Pragma", "no-cache");
        }
        return Action.CONTINUE;
    }

    public boolean injectCacheHeaders() {
        return this.injectCacheHeaders;
    }

    public boolean writeHeaders() {
        return this.writeHeaders;
    }

    public CacheHeadersInterceptor injectCacheHeaders(boolean injectCacheHeaders) {
        this.injectCacheHeaders = injectCacheHeaders;
        return this;
    }

    public CacheHeadersInterceptor writeHeaders(boolean writeHeaders) {
        this.writeHeaders = writeHeaders;
        return this;
    }

    @Override
    public String toString() {
        return "Default Response's Headers Interceptor";
    }
}

