/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceSession;
import org.atmosphere.cpr.AtmosphereResourceSessionFactory;
import org.atmosphere.cpr.DefaultAtmosphereResourceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtmosphereResourceSessionFactory
implements AtmosphereResourceSessionFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAtmosphereResourceSessionFactory.class);
    private final ConcurrentMap<String, AtmosphereResourceSession> sessions = new ConcurrentHashMap<String, AtmosphereResourceSession>();
    private final AtmosphereResourceEventListener disconnectListener = new AtmosphereResourceEventListenerAdapter(){

        @Override
        public void onDisconnect(AtmosphereResourceEvent event) {
            AtmosphereResource resource = event.getResource();
            if (resource == null) {
                logger.trace("Resource already destroyed, skipping session cleanup");
                return;
            }
            String uuid = resource.uuid();
            AtmosphereResourceSession session = (AtmosphereResourceSession)DefaultAtmosphereResourceSessionFactory.this.sessions.remove(uuid);
            if (session != null) {
                session.invalidate();
            }
        }

        public String toString() {
            return "DefaultAtmosphereResourceSessionFactory.disconnectListener";
        }
    };

    @Override
    public AtmosphereResourceSession getSession(AtmosphereResource r, boolean create) {
        AtmosphereResourceSession session = (AtmosphereResourceSession)this.sessions.get(r.uuid());
        if (create && session == null) {
            r.addEventListener(this.getDisconnectListener());
            session = new DefaultAtmosphereResourceSession();
            AtmosphereResourceSession existing = this.sessions.putIfAbsent(r.uuid(), session);
            if (existing != null) {
                session = existing;
            }
        }
        return session;
    }

    @Override
    public AtmosphereResourceSession getSession(AtmosphereResource resource) {
        return this.getSession(resource, true);
    }

    @Override
    public void destroy() {
        this.sessions.clear();
    }

    protected AtmosphereResourceEventListener getDisconnectListener() {
        return this.disconnectListener;
    }
}

