/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereServlet
extends HttpServlet {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    protected AtmosphereFramework framework;
    protected boolean isFilter;
    protected boolean autoDetectHandlers;

    public AtmosphereServlet() {
        this(false);
    }

    public AtmosphereServlet(boolean isFilter) {
        this(isFilter, true);
    }

    public AtmosphereServlet(boolean isFilter, boolean autoDetectHandlers) {
        this.isFilter = isFilter;
        this.autoDetectHandlers = autoDetectHandlers;
    }

    public void destroy() {
        if (this.framework != null) {
            this.framework.destroy();
            this.framework = null;
        }
    }

    public void init(ServletConfig sc) throws ServletException {
        this.configureFramework(sc);
        super.init(sc);
    }

    protected AtmosphereServlet configureFramework(ServletConfig sc) throws ServletException {
        if (this.framework == null) {
            if (sc.getServletContext().getMajorVersion() > 2) {
                try {
                    this.framework = (AtmosphereFramework)sc.getServletContext().getAttribute(sc.getServletContext().getServletRegistration(sc.getServletName()).getName());
                }
                catch (Exception ex) {
                    if (UnsupportedOperationException.class.isAssignableFrom(ex.getClass())) {
                        logger.warn("WebLogic 12c unable to retrieve Servlet. Please make sure your servlet-name is 'AtmosphereServlet' or set org.atmosphere.servlet to the current value");
                        String name = sc.getInitParameter("org.atmosphere.servlet");
                        if (name == null) {
                            name = AtmosphereServlet.class.getSimpleName();
                        }
                        this.framework = (AtmosphereFramework)sc.getServletContext().getAttribute(name);
                    }
                    logger.trace("", (Throwable)ex);
                }
            }
            if (this.framework == null) {
                this.framework = this.newAtmosphereFramework();
            }
        }
        this.framework.init(sc);
        return this;
    }

    protected AtmosphereFramework newAtmosphereFramework() {
        return new AtmosphereFramework(this.isFilter, this.autoDetectHandlers);
    }

    public AtmosphereFramework framework() {
        if (this.framework == null) {
            this.framework = this.newAtmosphereFramework();
        }
        return this.framework;
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.framework.doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
    }
}

