/*
 * Copyright 2014 Jeanfrancois Arcand
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.atmosphere.annotation;

import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.service.BroadcasterCacheListenerService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.BroadcasterCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(BroadcasterCacheListenerService.class)
public class BroadcasterCacheListenererviceProcessor implements Processor<BroadcasterCacheListener> {

    private static final Logger logger = LoggerFactory.getLogger(BroadcasterCacheListenererviceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<BroadcasterCacheListener> annotatedClass) {
        try {
            framework.addBroadcasterCacheListener(framework.newClassInstance(BroadcasterCacheListener.class, annotatedClass));
        } catch (Exception e) {
            logger.warn("", e);
        }
    }
}
