/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatInterceptor
extends AtmosphereInterceptorAdapter {
    public static final String HEARTBEAT_INTERVAL_IN_SECONDS = HeartbeatInterceptor.class.getName() + ".heartbeatFrequencyInSeconds";
    public static final String INTERCEPTOR_ADDED = HeartbeatInterceptor.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatInterceptor.class);
    private ScheduledExecutorService heartBeat;
    private static final String paddingText;
    private int heartbeatFrequencyInSeconds = 30;

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(HEARTBEAT_INTERVAL_IN_SECONDS);
        if (s != null) {
            this.heartbeatFrequencyInSeconds = Integer.valueOf(s);
        }
        this.heartBeat = ExecutorsFactory.getScheduler(config);
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING) || r.transport().equals((Object)AtmosphereResource.TRANSPORT.SSE) || r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass()) && r.getRequest().getAttribute(INTERCEPTOR_ADDED) == null) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){
                    Future<?> writeFuture;

                    @Override
                    public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
                        if (this.writeFuture != null) {
                            this.writeFuture.cancel(false);
                        }
                        return responseDraft;
                    }

                    @Override
                    public void postPayload(final AtmosphereResponse response, byte[] data, int offset, int length) {
                        logger.trace("Scheduling heartbeat for {}", (Object)r.uuid());
                        this.writeFuture = HeartbeatInterceptor.this.heartBeat.schedule(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                logger.trace("Writing heartbeat for {}", (Object)r.uuid());
                                if (r.isSuspended()) {
                                    try {
                                        response.write(paddingText, false);
                                    }
                                    catch (Throwable t) {
                                        logger.trace("{}", (Object)r.uuid(), (Object)t);
                                        try {
                                            ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).cancel();
                                            r.notifyListeners(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r), true, false));
                                        }
                                        catch (IOException e) {
                                            logger.trace("{}", (Throwable)e);
                                        }
                                        writeFuture.cancel(false);
                                    }
                                } else {
                                    writeFuture.cancel(false);
                                }
                                return null;
                            }
                        }, (long)HeartbeatInterceptor.this.heartbeatFrequencyInSeconds, TimeUnit.SECONDS);
                    }
                });
                r.getRequest().setAttribute(INTERCEPTOR_ADDED, Boolean.TRUE);
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "Heartbeat Interceptor Support";
    }

    static {
        StringBuffer whitespace = new StringBuffer();
        for (int i = 0; i < 8192; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        paddingText = whitespace.toString();
    }
}

