/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Map;
import java.util.WeakHashMap;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocketProcessor;

public class WebSocketProcessorFactory {
    private static WebSocketProcessorFactory factory;
    private final Map<AtmosphereFramework, WebSocketProcessor> processors = new WeakHashMap<AtmosphereFramework, WebSocketProcessor>();

    public static final synchronized WebSocketProcessorFactory getDefault() {
        if (factory == null) {
            factory = new WebSocketProcessorFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocketProcessor getWebSocketProcessor(AtmosphereFramework framework) {
        WebSocketProcessor processor = this.processors.get(framework);
        if (processor == null) {
            AtmosphereFramework atmosphereFramework = framework;
            synchronized (atmosphereFramework) {
                processor = this.createProcessor(framework);
                this.processors.put(framework, processor);
            }
        }
        return processor;
    }

    public synchronized void destroy() {
        for (WebSocketProcessor processor : this.processors.values()) {
            processor.destroy();
        }
        this.processors.clear();
    }

    private WebSocketProcessor createProcessor(AtmosphereFramework framework) {
        WebSocketProcessor processor = null;
        String webSocketProcessorName = framework.getWebSocketProcessorClassName();
        if (!webSocketProcessorName.equalsIgnoreCase(DefaultWebSocketProcessor.class.getName())) {
            try {
                processor = (WebSocketProcessor)Thread.currentThread().getContextClassLoader().loadClass(webSocketProcessorName).newInstance();
            }
            catch (Exception ex) {
                try {
                    processor = (WebSocketProcessor)this.getClass().getClassLoader().loadClass(webSocketProcessorName).newInstance();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
        if (processor == null) {
            processor = new DefaultWebSocketProcessor(framework);
        }
        return processor;
    }
}

