/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpProtocol
implements WebSocketProtocol,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(SimpleHttpProtocol.class);
    private String contentType = "text/plain";
    private String methodType = "POST";
    private String delimiter = "@@";
    private boolean destroyable;

    @Override
    public void configure(AtmosphereConfig config) {
        String contentType = config.getInitParameter("org.atmosphere.websocket.messageContentType");
        if (contentType == null) {
            contentType = "text/plain";
        }
        this.contentType = contentType;
        String methodType = config.getInitParameter("org.atmosphere.websocket.messageMethod");
        if (methodType == null) {
            methodType = "POST";
        }
        this.methodType = methodType;
        String delimiter = config.getInitParameter("org.atmosphere.websocket.pathDelimiter");
        if (delimiter == null) {
            delimiter = "@@";
        }
        this.delimiter = delimiter;
        String s = config.getInitParameter(ApplicationConfig.RECYCLE_ATMOSPHERE_REQUEST_RESPONSE);
        this.destroyable = s != null && Boolean.valueOf(s) != false;
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, String d) {
        int delimiterLength;
        int bodyBeginIndex;
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        if (resource == null) {
            logger.trace("The WebSocket has been closed before the message was processed.");
            return null;
        }
        AtmosphereRequest request = resource.getRequest();
        String pathInfo = request.getPathInfo();
        String requestURI = request.getRequestURI();
        if (d.startsWith(this.delimiter) && (bodyBeginIndex = d.indexOf(this.delimiter, delimiterLength = this.delimiter.length())) != -1) {
            pathInfo = d.substring(delimiterLength, bodyBeginIndex);
            requestURI = requestURI + pathInfo;
            d = d.substring(bodyBeginIndex + delimiterLength);
        }
        Map<String, Object> m = this.attributes(request);
        ArrayList<AtmosphereRequest> list = new ArrayList<AtmosphereRequest>();
        list.add(new AtmosphereRequest.Builder().request((HttpServletRequest)request).method(this.methodType).contentType(this.contentType).body(d).attributes(m).pathInfo(pathInfo).requestURI(requestURI).destroyable(this.destroyable).headers(request.headersMap()).session(resource.session()).build());
        return list;
    }

    private Map<String, Object> attributes(AtmosphereRequest request) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("websocket-subprotocol", "polling-websocket-message");
        m.putAll(request.attributes());
        return m;
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] d, int offset, int length) {
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        if (resource == null) {
            logger.trace("The WebSocket has been closed before the message was processed.");
            return null;
        }
        AtmosphereRequest request = resource.getRequest();
        String pathInfo = request.getPathInfo();
        String requestURI = request.getRequestURI();
        Map<String, Object> m = this.attributes(request);
        ArrayList<AtmosphereRequest> list = new ArrayList<AtmosphereRequest>();
        list.add(new AtmosphereRequest.Builder().request((HttpServletRequest)request).method(this.methodType).contentType(this.contentType).body(d, offset, length).attributes(m).pathInfo(pathInfo).requestURI(requestURI).destroyable(this.destroyable).headers(request.headersMap()).session(resource.session()).build());
        return list;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
    }

    @Override
    public void onClose(WebSocket webSocket) {
    }

    @Override
    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        logger.warn(t.getMessage() + " Status {} Message {}", (Object)t.response().getStatus(), (Object)t.response().getStatusMessage());
    }
}

