/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;

public class AtmosphereResourceEventImpl
implements AtmosphereResourceEvent {
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final AtomicBoolean isResumedOnTimeout = new AtomicBoolean(false);
    private Throwable throwable;
    protected Object message;
    protected AtmosphereResourceImpl resource;
    private final AtomicBoolean isClosedByClient = new AtomicBoolean(false);
    private final String uuid;
    private final AtomicBoolean isClosedByApplication = new AtomicBoolean(false);

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource) {
        this.resource = resource;
        this.throwable = null;
        this.uuid = resource.uuid();
    }

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource, boolean isCancelled, boolean isResumedOnTimeout) {
        this.isCancelled.set(isCancelled);
        this.isResumedOnTimeout.set(isResumedOnTimeout);
        this.resource = resource;
        this.throwable = null;
        this.uuid = resource.uuid();
    }

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource, boolean isCancelled, boolean isResumedOnTimeout, Throwable throwable) {
        this.isCancelled.set(isCancelled);
        this.isResumedOnTimeout.set(isResumedOnTimeout);
        this.resource = resource;
        this.throwable = throwable;
        this.uuid = resource.uuid();
    }

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource, boolean isCancelled, boolean isResumedOnTimeout, boolean isClosedByClient, Throwable throwable) {
        this.isCancelled.set(isCancelled);
        this.isResumedOnTimeout.set(isResumedOnTimeout);
        this.resource = resource;
        this.throwable = throwable;
        this.isClosedByClient.set(isClosedByClient);
        this.uuid = resource.uuid();
    }

    @Override
    public boolean isResuming() {
        return this.resource == null ? false : this.resource.action().type() == Action.TYPE.RESUME;
    }

    @Override
    public boolean isSuspended() {
        return this.resource == null ? false : this.resource.action().type() == Action.TYPE.SUSPEND;
    }

    @Override
    public boolean isClosedByClient() {
        return this.isClosedByClient.get();
    }

    @Override
    public boolean isClosedByApplication() {
        return this.isClosedByApplication.get();
    }

    public AtmosphereResourceEventImpl setCloseByApplication(boolean b) {
        this.isClosedByApplication.set(b);
        return this;
    }

    @Override
    public Object getMessage() {
        return this.message;
    }

    @Override
    public AtmosphereResourceEventImpl setMessage(Object message) {
        this.message = message;
        return this;
    }

    public AtmosphereResourceEventImpl isClosedByClient(boolean isClosedByClient) {
        this.isClosedByClient.set(isClosedByClient);
        return this;
    }

    @Override
    public boolean isResumedOnTimeout() {
        return this.isResumedOnTimeout.get();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    protected AtmosphereResourceEventImpl setCancelled(boolean isCancelled) {
        this.check();
        this.resource.action().type(Action.TYPE.CANCELLED);
        this.isCancelled.set(isCancelled);
        return this;
    }

    protected AtmosphereResourceEventImpl setIsResumedOnTimeout(boolean isResumedOnTimeout) {
        this.check();
        this.resource.action().type(Action.TYPE.TIMEOUT);
        this.isResumedOnTimeout.set(isResumedOnTimeout);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtmosphereResourceEventImpl that = (AtmosphereResourceEventImpl)o;
        if (this.isCancelled != null ? !this.isCancelled.equals(that.isCancelled) : that.isCancelled != null) {
            return false;
        }
        if (this.isResumedOnTimeout != null ? !this.isResumedOnTimeout.equals(that.isResumedOnTimeout) : that.isResumedOnTimeout != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        return !(this.throwable != null ? !this.throwable.equals(that.throwable) : that.throwable != null);
    }

    public int hashCode() {
        int result = this.isCancelled != null ? this.isCancelled.hashCode() : 0;
        result = 31 * result + (this.isResumedOnTimeout != null ? this.isResumedOnTimeout.hashCode() : 0);
        result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
        return result;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    @Override
    public Broadcaster broadcaster() {
        return this.resource.getBroadcaster();
    }

    @Override
    public AtmosphereResource getResource() {
        return this.resource;
    }

    private void check() {
        if (this.resource == null) {
            throw new IllegalStateException("Recycled");
        }
    }

    public AtmosphereResourceEvent setThrowable(Throwable t) {
        this.throwable = t;
        return this;
    }

    public AtmosphereResourceEvent destroy() {
        this.isCancelled.set(true);
        this.resource = null;
        this.message = null;
        return this;
    }

    public String toString() {
        return "AtmosphereResourceEventImpl{\n\t message=" + this.message + "\n\t isCancelled=" + this.isCancelled + "\n\t isResumedOnTimeout=" + this.isResumedOnTimeout + "\n\t throwable=" + this.throwable + "\n\t resource=" + this.uuid + '}';
    }
}

