/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jboss.websockets.oio.internal.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class Hash {
    static final String secureRandomAlgorithm = "SHA1PRNG";
    static final String hashAlgorithm = "SHA1";
    static final SecureRandom random;
    static final byte[] seed;
    private static int hashCounter;

    private Hash() {
    }

    public static byte[] getRandomBytes(byte[] bytes) {
        if (hashCounter < 0) {
            hashCounter -= hashCounter;
        }
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(seed[(i + ++hashCounter) % seed.length] % 127);
            if (hashCounter % 1000 > 500) {
                bytes[i] = -bytes[i];
            }
            if (hashCounter % 500 != 0) continue;
            random.nextBytes(seed);
        }
        return bytes;
    }

    public static String newUniqueHash() {
        return Hash.nextSecureHash(hashAlgorithm, Hash.getRandomBytes(new byte[64]));
    }

    private static String nextSecureHash(String algorithm, byte[] additionalSeed) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(String.valueOf(System.nanoTime()).getBytes());
            if (additionalSeed != null) {
                md.update(additionalSeed);
            }
            byte[] randBytes = new byte[32];
            Hash.getRandomBytes(randBytes);
            for (int i = 0; i < 1000; ++i) {
                md.update(md.digest());
            }
            return Hash.hashToHexString(md.digest());
        }
        catch (Exception e) {
            throw new RuntimeException("failed to generate session id hash", e);
        }
    }

    public static String hashToHexString(byte[] hash) {
        StringBuilder hexString = new StringBuilder(hash.length);
        for (byte mdbyte : hash) {
            hexString.append(Integer.toHexString(0xFF & mdbyte));
        }
        return hexString.toString();
    }

    static {
        hashCounter = 0;
        try {
            random = SecureRandom.getInstance(secureRandomAlgorithm);
            random.setSeed(SecureRandom.getInstance(secureRandomAlgorithm).generateSeed(64));
            hashCounter = random.nextInt();
            seed = new byte[512];
            random.nextBytes(seed);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("runtime does not support secure random algorithm: SHA1PRNG");
        }
    }
}

