/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jboss.websockets.oio.internal;

import org.atmosphere.jboss.websockets.oio.HttpRequestBridge;
import org.atmosphere.jboss.websockets.oio.HttpResponseBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WebSocketHeaders {
    SEC_WEBSOCKET_KEY("Sec-WebSocket-Key"),
    SEC_WEBSOCKET_KEY1("Sec-WebSocket-Key1"),
    SEC_WEBSOCKET_KEY2("Sec-WebSocket-Key2"),
    SEC_WEBSOCKET_LOCATION("Sec-WebSocket-Location"),
    ORIGIN("Origin"),
    SEC_WEBSOCKET_ORIGIN("Sec-WebSocket-Origin"),
    SEC_WEBSOCKET_PROTOCOL("Sec-WebSocket-Protocol"),
    SEC_WEBSOCKET_VERSION("Sec-WebSocket-Version"),
    SEC_WEBSOCKET_ACCEPT("Sec-WebSocket-Accept");

    private final String canonicalHeaderName;

    private WebSocketHeaders(String canonicalHeaderName) {
        this.canonicalHeaderName = canonicalHeaderName;
    }

    public final String getCanonicalHeaderName() {
        return this.canonicalHeaderName;
    }

    public final String get(HttpRequestBridge request) {
        return request.getHeader(this.getCanonicalHeaderName());
    }

    public final String get(HttpResponseBridge response) {
        return response.getHeader(this.getCanonicalHeaderName());
    }

    public final boolean isIn(HttpRequestBridge request) {
        return this.get(request) != null;
    }

    public final boolean isIn(HttpResponseBridge response) {
        return this.get(response) != null;
    }

    public final void copy(HttpRequestBridge from, HttpResponseBridge response) {
        if (this.isIn(from)) {
            this.set(response, this.get(from));
        }
    }

    public final void set(HttpResponseBridge response, String value) {
        response.setHeader(this.getCanonicalHeaderName(), value);
    }

    public final boolean matches(HttpRequestBridge request, String matchTo) {
        String val = this.get(request);
        return val != null && val.equals(matchTo);
    }

    public final boolean matches(HttpResponseBridge request, String matchTo) {
        String val = this.get(request);
        return val != null && val.equals(matchTo);
    }
}

