/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jboss.as.websockets.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.jboss.as.websockets.WebSocket;
import org.atmosphere.jboss.as.websockets.servlet.WebSocketDelegate;
import org.atmosphere.jboss.websockets.oio.ClosingStrategy;
import org.atmosphere.jboss.websockets.oio.HttpRequestBridge;
import org.atmosphere.jboss.websockets.oio.HttpResponseBridge;
import org.atmosphere.jboss.websockets.oio.OioWebSocket;
import org.atmosphere.jboss.websockets.oio.WebSocketConnectionManager;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.jboss.servlet.http.UpgradableHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketServlet
extends HttpServlet
implements HttpEventServlet {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServlet.class);
    private final String protocolName;
    private static final String SESSION_WEBSOCKET_HANDLE = "JBoss:AS:WebSocket:Handle";

    protected WebSocketServlet(String protocolName) {
        this.protocolName = protocolName;
    }

    protected WebSocketServlet() {
        this.protocolName = null;
    }

    public final void event(final HttpEvent event) throws IOException, ServletException {
        final HttpServletRequest request = event.getHttpServletRequest();
        final HttpServletResponse response = event.getHttpServletResponse();
        switch (event.getType()) {
            case BEGIN: {
                event.setTimeout(20000);
                if (response instanceof UpgradableHttpServletResponse) {
                    HttpRequestBridge requestBridge = new HttpRequestBridge(){

                        public String getHeader(String name) {
                            return request.getHeader(name);
                        }

                        public String getRequestURI() {
                            return request.getRequestURI();
                        }

                        public InputStream getInputStream() {
                            try {
                                return request.getInputStream();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                    HttpResponseBridge responseBridge = new HttpResponseBridge(){

                        public String getHeader(String name) {
                            return response.getHeader(name);
                        }

                        public void setHeader(String name, String val) {
                            response.setHeader(name, val);
                        }

                        public OutputStream getOutputStream() {
                            try {
                                return response.getOutputStream();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public void startUpgrade() {
                            ((UpgradableHttpServletResponse)response).startUpgrade();
                        }

                        public void sendUpgrade() throws IOException {
                            ((UpgradableHttpServletResponse)response).sendUpgrade();
                        }
                    };
                    OioWebSocket oioWebSocket = WebSocketConnectionManager.establish(this.protocolName, requestBridge, responseBridge, new ClosingStrategy(){

                        public void doClose() throws IOException {
                            event.close();
                        }
                    });
                    WebSocketDelegate webSocket = new WebSocketDelegate(request, oioWebSocket);
                    request.setAttribute(SESSION_WEBSOCKET_HANDLE, (Object)webSocket);
                    this.onSocketOpened(webSocket);
                    break;
                }
                throw new IllegalStateException("cannot upgrade connection");
            }
            case END: {
                break;
            }
            case ERROR: {
                event.close();
                break;
            }
            case EVENT: 
            case READ: {
                while (event.isReadReady()) {
                    this.onReceivedFrame((WebSocket)request.getAttribute(SESSION_WEBSOCKET_HANDLE));
                }
                break;
            }
            case TIMEOUT: {
                event.resume();
                break;
            }
            case EOF: {
                this.onSocketClosed((WebSocket)request.getAttribute(SESSION_WEBSOCKET_HANDLE));
            }
        }
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    protected final long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected final void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected final void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected final void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public final void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    protected void onSocketOpened(WebSocket socket) throws IOException {
    }

    protected void onSocketClosed(WebSocket socket) throws IOException {
    }

    protected void onReceivedFrame(WebSocket socket) throws IOException {
    }
}

