/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;

public class JavaScriptProtocol
implements AtmosphereInterceptor {
    private String wsDelimiter = "|";

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.MESSAGE_DELIMITER);
        if (s != null) {
            this.wsDelimiter = s;
        }
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        String uuid = r.getRequest().getHeader("X-Atmosphere-tracking-id");
        String handshakeUUID = r.getRequest().getHeader("X-atmo-protocol");
        if (uuid != null && uuid.equals("0") && handshakeUUID != null) {
            r.getRequest().header("X-atmo-protocol", null);
            r.getResponse().write(r.uuid() + this.wsDelimiter + System.currentTimeMillis());
            if (r.transport() == AtmosphereResource.TRANSPORT.WEBSOCKET || r.transport() == AtmosphereResource.TRANSPORT.STREAMING || r.transport() == AtmosphereResource.TRANSPORT.SSE) {
                return Action.CONTINUE;
            }
            return Action.CANCELLED;
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public String toString() {
        return "Atmosphere JavaScript Protocol";
    }
}

