/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.atmosphere.config.service.Delete;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.Get;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.Post;
import org.atmosphere.config.service.Put;
import org.atmosphere.config.service.Resume;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedAtmosphereHandler
implements AtmosphereHandler {
    private Logger logger = LoggerFactory.getLogger(ManagedAtmosphereHandler.class);
    private final Object object;
    private final Method onMessageMethod;
    private final Method onDisconnectMethod;
    private final Method onTimeoutMethod;
    private final Method onGetMethod;
    private final Method onPostMethod;
    private final Method onPutMethod;
    private final Method onDeleteMethod;

    public ManagedAtmosphereHandler(Object c) {
        this.object = c;
        this.onMessageMethod = this.populate(c, Message.class);
        this.onDisconnectMethod = this.populate(c, Disconnect.class);
        this.onTimeoutMethod = this.populate(c, Resume.class);
        this.onGetMethod = this.populate(c, Get.class);
        this.onPostMethod = this.populate(c, Post.class);
        this.onPutMethod = this.populate(c, Put.class);
        this.onDeleteMethod = this.populate(c, Delete.class);
    }

    @Override
    public void onRequest(AtmosphereResource resource) throws IOException {
        AtmosphereRequest request = resource.getRequest();
        String method = request.getMethod();
        if (method.equalsIgnoreCase("get")) {
            this.invoke(this.onGetMethod, resource);
        } else if (method.equalsIgnoreCase("post")) {
            this.invoke(this.onPostMethod, resource);
        } else if (method.equalsIgnoreCase("delete")) {
            this.invoke(this.onDeleteMethod, resource);
        } else if (method.equalsIgnoreCase("put")) {
            this.invoke(this.onPutMethod, resource);
        }
    }

    @Override
    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        AtmosphereResource resource = event.getResource();
        if (event.isCancelled()) {
            this.invoke(this.onDisconnectMethod, resource);
        } else if (event.isResumedOnTimeout() || event.isResuming()) {
            this.invoke(this.onTimeoutMethod, resource);
        } else {
            String message = event.getMessage().toString();
            this.invoke(this.onMessageMethod, event);
        }
    }

    @Override
    public void destroy() {
    }

    private Method populate(Object c, Class<? extends Annotation> annotation) {
        for (Method m : c.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            return m;
        }
        return null;
    }

    private Object invoke(Method m, Object o) {
        if (m != null) {
            try {
                Object[] objectArray;
                if (o == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = o;
                }
                return m.invoke(this.object, objectArray);
            }
            catch (IllegalAccessException e) {
                this.logger.debug("", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.logger.debug("", (Throwable)e);
            }
        }
        return null;
    }
}

