/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import eu.infomas.annotation.AnnotationDetector;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cache.EventCacheBroadcasterCache;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.config.service.AsyncSupportListenerService;
import org.atmosphere.config.service.AsyncSupportService;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.config.service.BroadcasterCacheInspectorService;
import org.atmosphere.config.service.BroadcasterCacheService;
import org.atmosphere.config.service.BroadcasterFactoryService;
import org.atmosphere.config.service.BroadcasterFilterService;
import org.atmosphere.config.service.BroadcasterListenerService;
import org.atmosphere.config.service.BroadcasterService;
import org.atmosphere.config.service.EndpoinMapperService;
import org.atmosphere.config.service.ManagedAtmosphereHandlerService;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.config.service.WebSocketProcessorService;
import org.atmosphere.config.service.WebSocketProtocolService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.handler.ManagedAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.BroadcastOnPostAtmosphereInterceptor;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnotationProcessor
implements AnnotationProcessor {
    protected AtmosphereFramework framework;
    private Logger logger = LoggerFactory.getLogger(DefaultAnnotationProcessor.class);

    @Override
    public AnnotationProcessor configure(AtmosphereFramework framework) {
        this.framework = framework;
        return this;
    }

    @Override
    public AnnotationProcessor scan(File rootDir) throws IOException {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        AnnotationDetector.TypeReporter reporter = new AnnotationDetector.TypeReporter(){

            public Class<? extends Annotation>[] annotations() {
                return new Class[]{AtmosphereHandlerService.class, BroadcasterCacheService.class, BroadcasterFilterService.class, BroadcasterFactoryService.class, BroadcasterService.class, MeteorService.class, WebSocketHandlerService.class, WebSocketProtocolService.class, AtmosphereInterceptorService.class, BroadcasterListenerService.class, AsyncSupportService.class, AsyncSupportListenerService.class, WebSocketProcessorService.class, BroadcasterCacheInspectorService.class, ManagedService.class, EndpoinMapperService.class, ManagedAtmosphereHandlerService.class};
            }

            /*
             * WARNING - void declaration
             */
            public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
                DefaultAnnotationProcessor.this.logger.info("Found Annotation in {} being scanned: {}", (Object)className, annotation);
                if (AtmosphereHandlerService.class.equals(annotation)) {
                    try {
                        String[] nv;
                        AtmosphereHandler handler = (AtmosphereHandler)cl.loadClass(className).newInstance();
                        AtmosphereHandlerService a = handler.getClass().getAnnotation(AtmosphereHandlerService.class);
                        DefaultAnnotationProcessor.this.framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
                        Class<? extends BroadcastFilter>[] bf = a.broadcastFilters();
                        for (Class<? extends BroadcastFilter> clazz : bf) {
                            DefaultAnnotationProcessor.this.framework.broadcasterFilters().add(clazz.getName());
                        }
                        for (String string : a.properties()) {
                            nv = string.split("=");
                            IntrospectionUtils.setProperty(handler, nv[0], nv[1]);
                            IntrospectionUtils.addProperty(handler, nv[0], nv[1]);
                        }
                        for (String string : a.atmosphereConfig()) {
                            nv = string.split("=");
                            DefaultAnnotationProcessor.this.framework.addInitParameter(nv[0], nv[1]);
                        }
                        Class<? extends AtmosphereInterceptor>[] interceptors = a.interceptors();
                        ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
                        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                            try {
                                AtmosphereInterceptor ai = i.newInstance();
                                ai.configure(DefaultAnnotationProcessor.this.framework.getAtmosphereConfig());
                                l.add(ai);
                            }
                            catch (Throwable e) {
                                DefaultAnnotationProcessor.this.logger.warn("", e);
                            }
                        }
                        DefaultAnnotationProcessor.this.framework.addAtmosphereHandler(a.path(), handler, l);
                        DefaultAnnotationProcessor.this.framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
                        DefaultAnnotationProcessor.this.framework.sessionSupport(a.supportSession());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterCacheService.class.equals(annotation)) {
                    DefaultAnnotationProcessor.this.framework.setBroadcasterCacheClassName(className);
                } else if (BroadcasterCacheInspectorService.class.equals(annotation)) {
                    try {
                        DefaultAnnotationProcessor.this.framework.addBroadcasterCacheInjector((BroadcasterCacheInspector)cl.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (MeteorService.class.equals(annotation)) {
                    try {
                        ReflectorServletProcessor r = new ReflectorServletProcessor();
                        r.setServletClassName(className);
                        Class<?> s = cl.loadClass(className);
                        MeteorService m = s.getAnnotation(MeteorService.class);
                        String mapping = m.path();
                        DefaultAnnotationProcessor.this.framework.setDefaultBroadcasterClassName(m.broadcaster().getName());
                        Class<? extends BroadcastFilter>[] bf = m.broadcastFilters();
                        for (Class<? extends BroadcastFilter> b : bf) {
                            DefaultAnnotationProcessor.this.framework.broadcasterFilters().add(b.getName());
                        }
                        for (String i : m.atmosphereConfig()) {
                            String[] nv = i.split("=");
                            DefaultAnnotationProcessor.this.framework.addInitParameter(nv[0], nv[1]);
                        }
                        Class<? extends AtmosphereInterceptor>[] interceptors = m.interceptors();
                        ArrayList<AtmosphereInterceptor> arrayList = new ArrayList<AtmosphereInterceptor>();
                        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                            try {
                                AtmosphereInterceptor ai = i.newInstance();
                                ai.configure(DefaultAnnotationProcessor.this.framework.getAtmosphereConfig());
                                arrayList.add(ai);
                            }
                            catch (Throwable e) {
                                DefaultAnnotationProcessor.this.logger.warn("", e);
                            }
                        }
                        DefaultAnnotationProcessor.this.framework.addAtmosphereHandler(mapping, (AtmosphereHandler)r, arrayList);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterFilterService.class.equals(annotation)) {
                    DefaultAnnotationProcessor.this.framework.broadcasterFilters().add(className);
                } else if (BroadcasterService.class.equals(annotation)) {
                    DefaultAnnotationProcessor.this.framework.setDefaultBroadcasterClassName(className);
                } else if (WebSocketHandlerService.class.equals(annotation)) {
                    try {
                        void var9_61;
                        Class<? extends BroadcastFilter>[] bf;
                        DefaultAnnotationProcessor.this.framework.initWebSocket();
                        Class<?> s = cl.loadClass(className);
                        WebSocketHandlerService m = s.getAnnotation(WebSocketHandlerService.class);
                        WebSocketProcessor p = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(DefaultAnnotationProcessor.this.framework);
                        p.registerWebSocketHandler(m.path(), (WebSocketHandler)s.newInstance());
                        DefaultAnnotationProcessor.this.framework.setDefaultBroadcasterClassName(m.broadcaster().getName());
                        Class<? extends BroadcastFilter>[] arr$ = bf = m.broadcastFilters();
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var9_61 < len$) {
                            Class<? extends BroadcastFilter> b = arr$[var9_61];
                            DefaultAnnotationProcessor.this.framework.broadcasterFilters().add(b.getName());
                            ++var9_61;
                        }
                        DefaultAnnotationProcessor.this.framework.setBroadcasterCacheClassName(m.broadcasterCache().getName());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (WebSocketProtocolService.class.equals(annotation)) {
                    DefaultAnnotationProcessor.this.framework.setWebSocketProtocolClassName(className);
                } else if (AtmosphereInterceptorService.class.equals(annotation)) {
                    try {
                        AtmosphereInterceptor a = (AtmosphereInterceptor)cl.loadClass(className).newInstance();
                        a.configure(DefaultAnnotationProcessor.this.framework.getAtmosphereConfig());
                        DefaultAnnotationProcessor.this.framework.interceptor(a);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (AsyncSupportService.class.equals(annotation)) {
                    try {
                        DefaultAnnotationProcessor.this.framework.setAsyncSupport(new DefaultAsyncSupportResolver(DefaultAnnotationProcessor.this.framework.config).newCometSupport(className));
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (AsyncSupportListenerService.class.equals(annotation)) {
                    try {
                        DefaultAnnotationProcessor.this.framework.asyncSupportListener((AsyncSupportListener)cl.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterFactoryService.class.equals(annotation)) {
                    try {
                        Class<?> bf = cl.loadClass(className);
                        DefaultAnnotationProcessor.this.framework.setBroadcasterFactory((BroadcasterFactory)bf.newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterListenerService.class.equals(annotation)) {
                    try {
                        DefaultAnnotationProcessor.this.framework.addBroadcastListener((BroadcasterListener)cl.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (WebSocketProcessorService.class.equals(annotation)) {
                    try {
                        DefaultAnnotationProcessor.this.framework.setWebsocketProcessorClassName(className);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (ManagedService.class.equals(annotation)) {
                    try {
                        void var9_63;
                        AtmosphereHandler handler = (AtmosphereHandler)cl.loadClass(className).newInstance();
                        ManagedService a = handler.getClass().getAnnotation(ManagedService.class);
                        Class[] interceptors = new Class[]{AtmosphereResourceLifecycleInterceptor.class, BroadcastOnPostAtmosphereInterceptor.class, TrackMessageSizeInterceptor.class, HeartbeatInterceptor.class};
                        ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
                        Class[] arr$ = interceptors;
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var9_63 < len$) {
                            Class i = arr$[var9_63];
                            try {
                                AtmosphereInterceptor ai = (AtmosphereInterceptor)i.newInstance();
                                ai.configure(DefaultAnnotationProcessor.this.framework.getAtmosphereConfig());
                                l.add(ai);
                            }
                            catch (Throwable e) {
                                DefaultAnnotationProcessor.this.logger.warn("", e);
                            }
                            ++var9_63;
                        }
                        final Class[] listeners = a.listeners();
                        try {
                            AtmosphereInterceptor ai = new AtmosphereInterceptor(){

                                @Override
                                public void configure(AtmosphereConfig config) {
                                }

                                @Override
                                public Action inspect(AtmosphereResource r) {
                                    for (Class l : listeners) {
                                        try {
                                            r.addEventListener((AtmosphereResourceEventListener)l.newInstance());
                                        }
                                        catch (Throwable e) {
                                            DefaultAnnotationProcessor.this.logger.warn("", e);
                                        }
                                    }
                                    return Action.CONTINUE;
                                }

                                @Override
                                public void postInspect(AtmosphereResource r) {
                                }
                            };
                            ai.configure(DefaultAnnotationProcessor.this.framework.getAtmosphereConfig());
                            l.add(ai);
                        }
                        catch (Throwable e) {
                            DefaultAnnotationProcessor.this.logger.warn("", e);
                        }
                        DefaultAnnotationProcessor.this.framework.addAtmosphereHandler(a.path(), handler, l);
                        DefaultAnnotationProcessor.this.framework.setBroadcasterCacheClassName(EventCacheBroadcasterCache.class.getName());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (EndpoinMapperService.class.equals(annotation)) {
                    try {
                        DefaultAnnotationProcessor.this.framework.endPointMapper((EndpointMapper)cl.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (ManagedAtmosphereHandlerService.class.equals(annotation)) {
                    try {
                        Object handler = cl.loadClass(className).newInstance();
                        ManagedAtmosphereHandlerService a = handler.getClass().getAnnotation(ManagedAtmosphereHandlerService.class);
                        Object c = cl.loadClass(className).newInstance();
                        ManagedAtmosphereHandler w = new ManagedAtmosphereHandler(c);
                        ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
                        DefaultAnnotationProcessor.this.framework.addAtmosphereHandler(a.path(), (AtmosphereHandler)w, l);
                    }
                    catch (Throwable t) {
                        DefaultAnnotationProcessor.this.logger.warn("", t);
                    }
                }
            }
        };
        this.logger.trace("Scanning @Service annotations in {}", (Object)rootDir.getAbsolutePath());
        AnnotationDetector cf = new AnnotationDetector((AnnotationDetector.Reporter)reporter);
        cf.detect(new File[]{rootDir});
        return this;
    }
}

