/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.util.Arrays;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.jboss.websockets.frame.BinaryFrame;
import org.atmosphere.jboss.websockets.frame.TextFrame;
import org.atmosphere.websocket.WebSocket;

public class JBossWebSocket
extends WebSocket {
    private final org.atmosphere.jboss.as.websockets.WebSocket webSocket;

    public JBossWebSocket(org.atmosphere.jboss.as.websockets.WebSocket webSocket, AtmosphereConfig config) {
        super(config);
        this.webSocket = webSocket;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public WebSocket write(String s) throws IOException {
        this.webSocket.writeFrame(TextFrame.from(s));
        return this;
    }

    @Override
    public WebSocket write(byte[] b, int offset, int length) throws IOException {
        this.webSocket.writeFrame(BinaryFrame.from(Arrays.copyOfRange(b, offset, length)));
        return this;
    }

    @Override
    public void close() {
        try {
            this.webSocket.closeSocket();
        }
        catch (IOException e) {
            logger.trace("Error closing websocket.", (Throwable)e);
        }
    }
}

