/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.atmosphere.container.version.TomcatWebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatWebSocketHandler
extends StreamInbound {
    private static final Logger logger = LoggerFactory.getLogger(TomcatWebSocketHandler.class);
    private final WebSocketProcessor webSocketProcessor;
    private final AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private WebSocket webSocket;

    public TomcatWebSocketHandler(AtmosphereRequest request, AtmosphereFramework framework, WebSocketProcessor webSocketProcessor) {
        this.request = request;
        this.framework = framework;
        this.webSocketProcessor = webSocketProcessor;
    }

    protected void onOpen(WsOutbound outbound) {
        logger.trace("WebSocket.onOpen.");
        this.webSocket = new TomcatWebSocket(outbound, this.framework.getAtmosphereConfig());
        try {
            this.webSocketProcessor.open(this.webSocket, this.request, AtmosphereResponse.newInstance(this.framework.getAtmosphereConfig(), this.request, this.webSocket));
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    protected void onClose(int closeCode) {
        this.request.destroy();
        if (this.webSocketProcessor == null) {
            return;
        }
        this.webSocketProcessor.close(this.webSocket, closeCode);
    }

    protected void onTextMessage(CharBuffer message) throws IOException {
        logger.trace("WebSocket.onMessage");
        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, message.toString());
    }

    protected final void onBinaryData(InputStream is) throws IOException {
        logger.trace("WebSocket.onBynaryStream");
        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, is);
    }

    protected final void onTextData(Reader r) throws IOException {
        logger.trace("WebSocket.onTextStream");
        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, r);
    }
}

