/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.FrameworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDisconnectInterceptor
implements AtmosphereInterceptor {
    private final Logger logger = LoggerFactory.getLogger(OnDisconnectInterceptor.class);
    private AsynchronousProcessor p;

    @Override
    public void configure(AtmosphereConfig config) {
        this.p = (AsynchronousProcessor)AsynchronousProcessor.class.cast(config.framework().getAsyncSupport());
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
        String s = request.getHeader("X-Atmosphere-Transport");
        String uuid = request.getHeader("X-Atmosphere-tracking-id");
        if (s != null && uuid != null && s.equalsIgnoreCase("close")) {
            this.logger.debug("AtmosphereResource {} disconnected", (Object)uuid);
            AtmosphereResource ss = AtmosphereResourceFactory.getDefault().find(uuid);
            if (ss != null) {
                ((AtmosphereResourceEventImpl)AtmosphereResourceEventImpl.class.cast(r.getAtmosphereResourceEvent())).isClosedByClient(true);
                ss.getRequest().setAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK, null);
                this.p.completeLifecycle(ss, false);
            }
            return Action.CANCELLED;
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public String toString() {
        return "Browser disconnection detection";
    }
}

