/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.cpr.PerRequestBroadcastFilter;
import org.atmosphere.di.InjectorProvider;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcasterConfig {
    private static final Logger logger = LoggerFactory.getLogger(BroadcasterConfig.class);
    protected final ConcurrentLinkedQueue<BroadcastFilter> filters = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<PerRequestBroadcastFilter> perRequestFilters = new ConcurrentLinkedQueue();
    private ExecutorService executorService;
    private ExecutorService asyncWriteService;
    private ScheduledExecutorService scheduler;
    private BroadcasterCache broadcasterCache = BroadcasterCache.DEFAULT;
    private final AtmosphereConfig config;
    private boolean isExecutorShared = false;
    private boolean isAsyncExecutorShared = false;
    private final boolean shared;
    private String name;
    private boolean handleExecutors;

    public BroadcasterConfig(List<String> list, AtmosphereConfig config, String name) {
        this(list, config, true, name);
    }

    public BroadcasterConfig(List<String> list, AtmosphereConfig config, boolean handleExecutors, String name) {
        this.config = config;
        this.name = name;
        this.shared = config.framework().isShareExecutorServices();
        if (handleExecutors) {
            this.configExecutors();
        }
        this.configureBroadcasterFilter(list);
        this.configureBroadcasterCache();
        this.configureSharedCacheExecutor();
        this.handleExecutors = handleExecutors;
    }

    public BroadcasterConfig(ExecutorService executorService, ExecutorService asyncWriteService, ScheduledExecutorService scheduler, AtmosphereConfig config, String name) {
        this.executorService = executorService;
        this.scheduler = scheduler;
        this.asyncWriteService = asyncWriteService;
        this.config = config;
        this.name = name;
        this.handleExecutors = true;
        this.shared = config.framework().isShareExecutorServices();
    }

    private void configureBroadcasterCache() {
        try {
            String className = this.config.framework().getBroadcasterCacheClassName();
            if (className != null) {
                try {
                    this.broadcasterCache = (BroadcasterCache)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
                }
                catch (ClassNotFoundException ex) {
                    this.broadcasterCache = (BroadcasterCache)this.getClass().getClassLoader().loadClass(className).newInstance();
                }
                InjectorProvider.getInjector().inject(this.broadcasterCache);
            }
            for (BroadcasterCacheInspector b : this.config.framework().inspectors()) {
                this.broadcasterCache.inspector(b);
                InjectorProvider.getInjector().inject(b);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configureSharedCacheExecutor() {
        if (!this.shared) {
            return;
        }
        this.config.properties().put("shared", "true");
        this.broadcasterCache.configure(this.config);
    }

    protected BroadcasterConfig broadcasterID(String name) {
        this.name = name;
        this.initClusterExtension();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClusterExtension() {
        for (BroadcastFilter mf : this.filters) {
            if (!ClusterBroadcastFilter.class.isAssignableFrom(mf.getClass())) continue;
            try {
                Object b = this.config.getBroadcasterFactory().lookup(this.name, false);
                if (b == null) continue;
                BroadcastFilter broadcastFilter = mf;
                synchronized (broadcastFilter) {
                    ((ClusterBroadcastFilter)ClusterBroadcastFilter.class.cast(mf)).setBroadcaster((Broadcaster)b);
                }
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }
    }

    protected synchronized void configExecutors() {
        if (this.shared) {
            this.handleExecutors = false;
            this.isExecutorShared = true;
            this.isAsyncExecutorShared = true;
        }
        this.executorService = ExecutorsFactory.getMessageDispatcher(this.config, this.name);
        this.asyncWriteService = ExecutorsFactory.getAsyncOperationExecutor(this.config, this.name);
        this.scheduler = ExecutorsFactory.getScheduler(this.config);
    }

    public BroadcasterConfig setExecutorService(ExecutorService executorService) {
        return this.setExecutorService(executorService, false);
    }

    public BroadcasterConfig setExecutorService(ExecutorService executorService, boolean isExecutorShared) {
        if (!this.isExecutorShared && this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = executorService;
        this.isExecutorShared = isExecutorShared;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public BroadcasterConfig setAsyncWriteService(ExecutorService asyncWriteService) {
        return this.setAsyncWriteService(asyncWriteService, false);
    }

    public BroadcasterConfig setAsyncWriteService(ExecutorService asyncWriteService, boolean isAsyncExecutorShared) {
        if (!this.isAsyncExecutorShared && this.asyncWriteService != null) {
            this.asyncWriteService.shutdown();
        }
        this.asyncWriteService = asyncWriteService;
        this.isAsyncExecutorShared = isAsyncExecutorShared;
        return this;
    }

    public ExecutorService getAsyncWriteService() {
        return this.asyncWriteService;
    }

    public boolean addFilter(BroadcastFilter e) {
        return this.addFilter(e, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addFilter(BroadcastFilter e, boolean init) {
        Object b;
        this.logDuplicateFilter(e);
        if (this.filters.contains(e)) {
            return false;
        }
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).init(this.config);
        }
        if (init && ClusterBroadcastFilter.class.isAssignableFrom(e.getClass()) && (b = this.config.getBroadcasterFactory().lookup(this.name, false)) != null) {
            BroadcastFilter broadcastFilter = e;
            synchronized (broadcastFilter) {
                ((ClusterBroadcastFilter)ClusterBroadcastFilter.class.cast(e)).setBroadcaster((Broadcaster)b);
            }
        }
        if (e instanceof PerRequestBroadcastFilter) {
            this.perRequestFilters.add((PerRequestBroadcastFilter)e);
        }
        return this.filters.offer(e);
    }

    private void logDuplicateFilter(BroadcastFilter e) {
        for (BroadcastFilter f : this.filters) {
            if (!f.getClass().isAssignableFrom(e.getClass())) continue;
            logger.trace("Duplicate Filter instance {}", f.getClass());
        }
    }

    public Collection<BroadcastFilter> filters() {
        return this.filters;
    }

    public void destroy() {
        this.destroy(false);
    }

    protected void destroy(boolean force) {
        if (!force && !this.handleExecutors) {
            return;
        }
        if ((force || !this.shared) && this.broadcasterCache != null) {
            this.broadcasterCache.stop();
        }
        if ((force || !this.isExecutorShared) && this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if ((force || !this.isAsyncExecutorShared) && this.asyncWriteService != null) {
            this.asyncWriteService.shutdownNow();
        }
        if ((force || !this.shared) && this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        for (BroadcastFilter f : this.filters) {
            if (!(f instanceof BroadcastFilterLifecycle)) continue;
            ((BroadcastFilterLifecycle)f).destroy();
        }
        this.removeAllFilters();
    }

    public void forceDestroy() {
        this.destroy(true);
    }

    public boolean removeFilter(BroadcastFilter filter) {
        if (filter instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)filter).destroy();
        }
        if (filter instanceof PerRequestBroadcastFilter) {
            this.perRequestFilters.remove(filter);
        }
        return this.filters.remove(filter);
    }

    public void removeAllFilters() {
        for (BroadcastFilter filter : this.filters) {
            this.removeFilter(filter);
        }
    }

    public boolean hasFilters() {
        return !this.filters.isEmpty();
    }

    public boolean hasPerRequestFilters() {
        if (this.filters.isEmpty()) {
            return false;
        }
        for (BroadcastFilter b : this.filters) {
            if (!PerRequestBroadcastFilter.class.isAssignableFrom(b.getClass())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BroadcastFilter.BroadcastAction filter(Object object) {
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(object);
        Iterator<BroadcastFilter> i$ = this.filters.iterator();
        while (i$.hasNext()) {
            BroadcastFilter mf;
            BroadcastFilter broadcastFilter = mf = i$.next();
            synchronized (broadcastFilter) {
                transformed = mf.filter(object, transformed.message());
                if (transformed == null || transformed.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT) {
                    return transformed;
                }
            }
        }
        return transformed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BroadcastFilter.BroadcastAction filter(AtmosphereResource r, Object message, Object originalMessage) {
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(message);
        Iterator<PerRequestBroadcastFilter> i$ = this.perRequestFilters.iterator();
        while (i$.hasNext()) {
            PerRequestBroadcastFilter mf;
            PerRequestBroadcastFilter perRequestBroadcastFilter = mf = i$.next();
            synchronized (perRequestBroadcastFilter) {
                transformed = mf.filter(r, originalMessage, transformed.message());
                if (transformed == null || transformed.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT) {
                    return transformed;
                }
            }
        }
        return transformed;
    }

    public BroadcasterConfig setScheduledExecutorService(ScheduledExecutorService scheduler) {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.scheduler = scheduler;
        return this;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduler;
    }

    public BroadcasterConfig setBroadcasterCache(BroadcasterCache broadcasterCache) {
        this.broadcasterCache = broadcasterCache;
        return this;
    }

    public BroadcasterCache getBroadcasterCache() {
        return this.broadcasterCache;
    }

    void configureBroadcasterFilter(List<String> list) {
        for (String broadcastFilter : list) {
            BroadcastFilter bf = null;
            try {
                bf = (BroadcastFilter)BroadcastFilter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(broadcastFilter).newInstance());
            }
            catch (InstantiationException e) {
                logger.warn("Error trying to instantiate BroadcastFilter: " + broadcastFilter, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Error trying to instantiate BroadcastFilter: " + broadcastFilter, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                try {
                    bf = (BroadcastFilter)BroadcastFilter.class.cast(BroadcastFilter.class.getClassLoader().loadClass(broadcastFilter).newInstance());
                }
                catch (InstantiationException e1) {
                }
                catch (IllegalAccessException e1) {
                }
                catch (ClassNotFoundException e1) {
                    logger.warn("Error trying to instantiate BroadcastFilter: " + broadcastFilter, (Throwable)e);
                }
            }
            if (bf == null) continue;
            InjectorProvider.getInjector().inject(bf);
            this.addFilter(bf);
        }
    }

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }
}

