/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.cpr.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResourceImpl
implements AtmosphereResource {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceImpl.class);
    public static final String PRE_SUSPEND = AtmosphereResourceImpl.class.getName() + ".preSuspend";
    public static final String SKIP_BROADCASTER_CREATION = AtmosphereResourceImpl.class.getName() + ".skipBroadcasterCreation";
    public static final String METEOR = Meteor.class.getName();
    private final AtmosphereRequest req;
    private final AtmosphereResponse response;
    protected final Action action = new Action();
    protected Broadcaster broadcaster;
    private final AtmosphereConfig config;
    protected final AsyncSupport asyncSupport;
    private Serializer serializer;
    private boolean isInScope = true;
    private final AtmosphereResourceEventImpl event;
    private String beginCompatibleData;
    private boolean useWriter = true;
    private boolean isResumed = false;
    private boolean isCancelled = false;
    private boolean resumeOnBroadcast = false;
    private Object writeOnTimeout = null;
    private boolean disableSuspend = false;
    private final ConcurrentLinkedQueue<AtmosphereResourceEventListener> listeners = new ConcurrentLinkedQueue();
    private final boolean injectCacheHeaders;
    private final boolean enableAccessControl;
    private final AtomicBoolean isSuspendEvent = new AtomicBoolean(false);
    private AtmosphereHandler atmosphereHandler;
    private final boolean writeHeaders;
    private String padding;
    private final String uuid;
    protected HttpSession session;

    public AtmosphereResourceImpl(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereRequest req, AtmosphereResponse response, AsyncSupport asyncSupport, AtmosphereHandler atmosphereHandler) {
        this.req = req;
        this.response = response;
        this.broadcaster = broadcaster;
        this.config = config;
        this.asyncSupport = asyncSupport;
        this.atmosphereHandler = atmosphereHandler;
        this.event = new AtmosphereResourceEventImpl(this);
        String nocache = config.getInitParameter(ApplicationConfig.NO_CACHE_HEADERS);
        this.injectCacheHeaders = nocache == null;
        String ac = config.getInitParameter(ApplicationConfig.DROP_ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        this.enableAccessControl = ac != null ? !Boolean.parseBoolean(ac) : true;
        String wh = config.getInitParameter(FrameworkConfig.WRITE_HEADERS);
        this.writeHeaders = wh != null ? Boolean.parseBoolean(wh) : true;
        req.setAttribute(ApplicationConfig.NO_CACHE_HEADERS, this.injectCacheHeaders);
        req.setAttribute(ApplicationConfig.DROP_ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, this.enableAccessControl);
        this.padding = config.getInitParameter(ApplicationConfig.STREAMING_PADDING_MODE);
        req.setAttribute(ApplicationConfig.STREAMING_PADDING_MODE, this.padding);
        String s = response.getHeader("X-Atmosphere-tracking-id");
        String string = this.uuid = s == null ? UUID.randomUUID().toString() : s;
        if (config.isSupportSession()) {
            try {
                this.session = req.getSession(true);
            }
            catch (NullPointerException ex) {
                logger.trace("http://java.net/jira/browse/GLASSFISH-18856", (Throwable)ex);
            }
        }
    }

    @Override
    public AtmosphereResourceEventImpl getAtmosphereResourceEvent() {
        return this.event;
    }

    @Override
    public AtmosphereHandler getAtmosphereHandler() {
        return this.atmosphereHandler;
    }

    @Override
    public AtmosphereResource writeOnTimeout(Object o) {
        this.writeOnTimeout = o;
        return this;
    }

    @Override
    public Object writeOnTimeout() {
        return this.writeOnTimeout;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public AtmosphereResource.TRANSPORT transport() {
        if (this.req == null) {
            return AtmosphereResource.TRANSPORT.UNDEFINED;
        }
        String s = this.req.getHeader("X-Atmosphere-Transport");
        if (s == null) {
            return AtmosphereResource.TRANSPORT.UNDEFINED;
        }
        s = s.replace("-", "_").toUpperCase();
        if (AtmosphereResource.TRANSPORT.POLLING.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.POLLING;
        }
        if (AtmosphereResource.TRANSPORT.LONG_POLLING.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.LONG_POLLING;
        }
        if (AtmosphereResource.TRANSPORT.STREAMING.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.STREAMING;
        }
        if (AtmosphereResource.TRANSPORT.JSONP.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.JSONP;
        }
        if (AtmosphereResource.TRANSPORT.WEBSOCKET.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.WEBSOCKET;
        }
        if (AtmosphereResource.TRANSPORT.SSE.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.SSE;
        }
        if (AtmosphereResource.TRANSPORT.AJAX.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.AJAX;
        }
        return AtmosphereResource.TRANSPORT.UNDEFINED;
    }

    @Override
    public AtmosphereResource resumeOnBroadcast(boolean resumeOnBroadcast) {
        this.resumeOnBroadcast = resumeOnBroadcast;
        this.req.setAttribute("org.atmosphere.resumeOnBroadcast", resumeOnBroadcast);
        return this;
    }

    @Override
    public boolean isSuspended() {
        return this.event.isSuspended();
    }

    @Override
    public boolean resumeOnBroadcast() {
        return this.resumeOnBroadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AtmosphereResource resume() {
        block23: {
            try {
                if (!this.isResumed && this.isInScope) {
                    this.action.type(Action.TYPE.RESUME);
                    this.isResumed = true;
                    Broadcaster b = this.getBroadcaster(false);
                    if (!b.isDestroyed() && b instanceof DefaultBroadcaster) {
                        ((DefaultBroadcaster)b).broadcastOnResume(this);
                    }
                    this.notifyListeners();
                    try {
                        if (!b.isDestroyed()) {
                            this.broadcaster.removeAtmosphereResource(this);
                        }
                    }
                    catch (IllegalStateException ex) {
                        logger.warn("Unable to resume", (Object)this);
                        logger.debug(ex.getMessage(), (Throwable)ex);
                    }
                    if (b.getScope() == Broadcaster.SCOPE.REQUEST) {
                        logger.debug("Broadcaster's scope is set to request, destroying it {}", (Object)b.getID());
                        b.destroy();
                    }
                    if (BroadcasterFactory.getDefault() != null) {
                        BroadcasterFactory.getDefault().removeAllAtmosphereResource(this);
                    }
                    try {
                        this.req.setAttribute("org.atmosphere.cpr.AtmosphereServlet.resumedOnTimeout", Boolean.FALSE);
                    }
                    catch (Exception ex) {
                        logger.debug("Resume exception: Cannot resume an already resumed/cancelled request", (Throwable)ex);
                    }
                    finally {
                        try {
                            Meteor m = (Meteor)this.req.getAttribute(METEOR);
                            if (m != null) {
                                m.destroy();
                            }
                        }
                        catch (Exception ex) {
                            logger.debug("Meteor resume exception: Cannot resume an already resumed/cancelled request", (Throwable)ex);
                        }
                    }
                    if (this.req.getAttribute(PRE_SUSPEND) == null) {
                        this.asyncSupport.action(this);
                    }
                    break block23;
                }
                logger.debug("Cannot resume an already resumed/cancelled request {}", (Object)this);
            }
            catch (Throwable t) {
                logger.trace("Wasn't able to resume a connection {}", (Object)this, (Object)t);
            }
        }
        this.notifyListeners(new AtmosphereResourceEventImpl(this, true, false));
        this.listeners.clear();
        return this;
    }

    @Override
    public AtmosphereResource suspend() {
        return this.suspend(-1L);
    }

    @Override
    public AtmosphereResource suspend(long timeout) {
        return this.suspend(timeout, true);
    }

    @Override
    public AtmosphereResource suspend(long timeout, TimeUnit timeunit) {
        return this.suspend(timeout, timeunit, true);
    }

    @Override
    public AtmosphereResource suspend(long timeout, TimeUnit timeunit, boolean flushComment) {
        long timeoutms = -1L;
        if (timeunit != null) {
            timeoutms = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        }
        return this.suspend(timeoutms, flushComment);
    }

    @Override
    public AtmosphereResource suspend(long timeout, boolean flushComment) {
        if (this.event.isSuspended() || this.disableSuspend) {
            return this;
        }
        if (this.req.getSession(false) != null && this.req.getSession().getMaxInactiveInterval() != -1 && (long)(this.req.getSession().getMaxInactiveInterval() * 1000) < timeout) {
            throw new IllegalStateException("Cannot suspend a response longer than the session timeout. Increase the value of session-timeout in web.xml");
        }
        if (this.req.getAttribute(DefaultBroadcaster.CACHED) != null) {
            this.req.removeAttribute(DefaultBroadcaster.CACHED);
            return this;
        }
        if (!this.event.isResumedOnTimeout()) {
            Enumeration connection = this.req.getHeaders("Connection");
            if (connection == null) {
                connection = this.req.getHeaders("connection");
            }
            if (connection != null && connection.hasMoreElements()) {
                String[] e;
                for (String upgrade : e = ((String)connection.nextElement()).toString().split(",")) {
                    if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                    if (this.writeHeaders && !this.asyncSupport.supportWebSocket()) {
                        this.response.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                        continue;
                    }
                    this.req.setAttribute(FrameworkConfig.TRANSPORT_IN_USE, "websocket");
                    flushComment = false;
                }
            }
            if (this.req.getHeader("X-Atmosphere-Transport") != null && !this.req.getHeader("X-Atmosphere-Transport").equalsIgnoreCase("streaming")) {
                flushComment = false;
            }
            if (flushComment) {
                this.req.setAttribute(FrameworkConfig.TRANSPORT_IN_USE, "streaming");
            } else if (this.req.getHeader("X-Atmosphere-Transport") == null) {
                this.req.setAttribute(FrameworkConfig.TRANSPORT_IN_USE, "long-polling");
            }
            if (this.writeHeaders && this.injectCacheHeaders) {
                this.response.setHeader("Expires", "-1");
                this.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
                this.response.setHeader("Pragma", "no-cache");
            }
            if (this.writeHeaders && this.enableAccessControl) {
                this.response.setHeader("Access-Control-Allow-Origin", this.req.getHeader("Origin") == null ? "*" : this.req.getHeader("Origin"));
                this.response.setHeader("Access-Control-Allow-Credentials", "true");
            }
            if (flushComment) {
                this.write(true);
            }
            this.req.setAttribute(PRE_SUSPEND, "true");
            this.action.type(Action.TYPE.SUSPEND);
            this.action.timeout(timeout);
            boolean isJersey = this.req.getAttribute("org.atmosphere.jersey.containerResponse") != null;
            boolean skipCreation = false;
            if (this.req.getAttribute(SKIP_BROADCASTER_CREATION) != null) {
                skipCreation = true;
            }
            if (!(skipCreation || this.broadcaster != null && this.broadcaster.getScope() != Broadcaster.SCOPE.REQUEST || isJersey)) {
                String id = this.broadcaster != null ? this.broadcaster.getID() : this.getClass().getName();
                Class<DefaultBroadcaster> clazz = this.broadcaster != null ? this.broadcaster.getClass() : DefaultBroadcaster.class;
                this.broadcaster = BroadcasterFactory.getDefault().lookup(clazz, id, false);
                if (this.broadcaster == null || this.broadcaster.getAtmosphereResources().size() > 0) {
                    this.broadcaster = BroadcasterFactory.getDefault().lookup(clazz, id + "/" + UUID.randomUUID(), true);
                }
            }
            this.broadcaster.addAtmosphereResource(this);
            this.req.removeAttribute(PRE_SUSPEND);
            this.notifyListeners();
        }
        return this;
    }

    void write(boolean flushPadding) {
        block10: {
            if (this.beginCompatibleData == null) {
                this.beginCompatibleData = AtmosphereResourceImpl.createStreamingPadding(this.padding);
            }
            try {
                if (this.useWriter && !((Boolean)this.req.getAttribute("org.atmosphere.useStream")).booleanValue()) {
                    try {
                        this.response.getWriter();
                    }
                    catch (IllegalStateException e) {
                        return;
                    }
                    if (flushPadding) {
                        this.response.getWriter().write(this.beginCompatibleData);
                    }
                    this.response.getWriter().flush();
                    break block10;
                }
                try {
                    this.response.getOutputStream();
                }
                catch (IllegalStateException e) {
                    return;
                }
                if (flushPadding) {
                    this.response.getOutputStream().write(this.beginCompatibleData.getBytes());
                }
                this.response.getOutputStream().flush();
            }
            catch (Throwable ex) {
                logger.warn("failed to write to response", ex);
            }
        }
    }

    public AtmosphereRequest getRequest(boolean enforceScope) {
        if (enforceScope && !this.isInScope) {
            throw new IllegalStateException("Request object no longer valid. This object has been cancelled");
        }
        return this.req;
    }

    public AtmosphereResponse getResponse(boolean enforceScope) {
        if (enforceScope && !this.isInScope) {
            throw new IllegalStateException("Response object no longer valid. This object has been cancelled");
        }
        return this.response;
    }

    @Override
    public AtmosphereRequest getRequest() {
        return this.getRequest(true);
    }

    @Override
    public AtmosphereResponse getResponse() {
        return this.getResponse(true);
    }

    @Override
    public Broadcaster getBroadcaster() {
        return this.getBroadcaster(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Broadcaster getBroadcaster(boolean autoCreate) {
        if (this.broadcaster == null) {
            throw new IllegalStateException("No Broadcaster associated with this AtmosphereResource.");
        }
        String s = this.config.getInitParameter(ApplicationConfig.RECOVER_DEAD_BROADCASTER);
        if (s != null) {
            autoCreate = Boolean.parseBoolean(s);
        }
        if (autoCreate && this.broadcaster.isDestroyed() && BroadcasterFactory.getDefault() != null) {
            logger.debug("Broadcaster {} has been destroyed and cannot be re-used. Recreating a new one with the same name. You can turn off that mechanism by adding, in web.xml, {} set to false", (Object)this.broadcaster.getID(), (Object)ApplicationConfig.RECOVER_DEAD_BROADCASTER);
            Broadcaster.SCOPE scope = this.broadcaster.getScope();
            AtmosphereResourceImpl atmosphereResourceImpl = this;
            synchronized (atmosphereResourceImpl) {
                String id = scope != Broadcaster.SCOPE.REQUEST ? this.broadcaster.getID() : this.broadcaster.getID() + ".recovered" + UUID.randomUUID();
                this.broadcaster = BroadcasterFactory.getDefault().lookup(id, true);
                this.broadcaster.setScope(scope);
                this.broadcaster.addAtmosphereResource(this);
            }
        }
        return this.broadcaster;
    }

    @Override
    public AtmosphereResourceImpl setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
        return this;
    }

    @Override
    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public Action action() {
        return this.action;
    }

    public void setIsInScope(boolean isInScope) {
        this.isInScope = isInScope;
    }

    public boolean isInScope() {
        return this.isInScope;
    }

    @Override
    public AtmosphereResource setSerializer(Serializer s) {
        this.serializer = s;
        return this;
    }

    @Override
    public boolean isResumed() {
        return this.isResumed;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public AtmosphereResource write(OutputStream os, Object o) throws IOException {
        if (o == null) {
            throw new IllegalStateException("Object cannot be null");
        }
        if (this.serializer != null) {
            this.serializer.write(os, o);
        } else {
            this.response.getOutputStream().write(o.toString().getBytes());
        }
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    public static String createStreamingPadding(String padding) {
        StringBuilder s = new StringBuilder();
        if (padding == null || padding.equalsIgnoreCase("atmosphere")) {
            s.append("<!-- ---------------------------------------------------------------- http://github.com/Atmosphere ------------------------------------------------------------------------ -->\n");
            s.append("<!-- Welcome to the Atmosphere Framework. To work with all the browsers when suspending connection, Atmosphere must output some data to makes WebKit based browser working.-->\n");
            for (int i = 0; i < 10; ++i) {
                s.append("<!-- --------------------------------------------------------------------------------------------------------------------------------------------------------------------- -->\n");
            }
            s.append("<!-- EOD -->");
        } else {
            for (int i = 0; i < 4096; ++i) {
                s.append(" ");
            }
        }
        return s.toString();
    }

    @Override
    public AtmosphereResource addEventListener(AtmosphereResourceEventListener e) {
        if (this.listeners.contains(e)) {
            return this;
        }
        this.listeners.add(e);
        return this;
    }

    @Override
    public AtmosphereResource removeEventListener(AtmosphereResourceEventListener e) {
        this.listeners.remove(e);
        return this;
    }

    @Override
    public AtmosphereResource removeEventListeners() {
        this.listeners.clear();
        return this;
    }

    @Override
    public AtmosphereResource notifyListeners() {
        this.notifyListeners(this.event);
        return this;
    }

    @Override
    public AtmosphereResource notifyListeners(AtmosphereResourceEvent event) {
        if (this.listeners.size() <= 0) {
            return this;
        }
        logger.trace("Invoking listener with {}", (Object)event);
        Action oldAction = this.action;
        try {
            if (event.isCancelled()) {
                this.onDisconnect(event);
            } else if (event.isResuming() || event.isResumedOnTimeout()) {
                this.onResume(event);
            } else if (!this.isSuspendEvent.getAndSet(true) && event.isSuspended()) {
                this.onSuspend(event);
            } else if (event.throwable() != null) {
                this.onThrowable(event);
            } else {
                this.onBroadcast(event);
            }
            if (oldAction.type() != this.action.type()) {
                this.action().type(Action.TYPE.CREATED);
            }
        }
        catch (Throwable t) {
            logger.trace("Listener error {}", t);
            ((AtmosphereResourceEventImpl)AtmosphereResourceEventImpl.class.cast(event)).setThrowable(t);
            try {
                this.onThrowable(event);
            }
            catch (Throwable t2) {
                logger.warn("Listener error {}", t2);
            }
        }
        return this;
    }

    public void onThrowable(Throwable t) {
        this.onThrowable(new AtmosphereResourceEventImpl(this, false, false, t));
    }

    void onThrowable(AtmosphereResourceEvent e) {
        AtmosphereHandler atmosphereHandler = (AtmosphereHandler)this.req.getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER);
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onThrowable(e);
        }
    }

    void onSuspend(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onSuspend(e);
        }
    }

    void onResume(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onResume(e);
        }
    }

    void onDisconnect(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onDisconnect(e);
        }
    }

    void onBroadcast(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onBroadcast(e);
        }
    }

    public ConcurrentLinkedQueue<AtmosphereResourceEventListener> atmosphereResourceEventListener() {
        return this.listeners;
    }

    public AtmosphereResourceImpl atmosphereHandler(AtmosphereHandler atmosphereHandler) {
        this.atmosphereHandler = atmosphereHandler;
        return this;
    }

    public synchronized void cancel() throws IOException {
        this.action.type(Action.TYPE.RESUME);
        this.isCancelled = true;
        this.asyncSupport.action(this);
        if (AtmosphereResponse.class.isAssignableFrom(((Object)((Object)this.response)).getClass())) {
            ((AtmosphereResponse)((Object)AtmosphereResponse.class.cast((Object)this.response))).close();
            ((AtmosphereResponse)((Object)AtmosphereResponse.class.cast((Object)this.response))).destroy();
        }
        if (AtmosphereRequest.class.isAssignableFrom(((Object)((Object)this.req)).getClass())) {
            ((AtmosphereRequest)((Object)AtmosphereRequest.class.cast((Object)this.req))).destroy();
        }
        if (this.broadcaster != null) {
            this.broadcaster.removeAtmosphereResource(this);
        }
        this.event.destroy();
    }

    public String toString() {
        return "AtmosphereResourceImpl{\n hasCode" + this.hashCode() + ",\n action=" + this.action + ",\n broadcaster=" + this.broadcaster.getClass().getName() + ",\n asyncSupport=" + this.asyncSupport + ",\n serializer=" + this.serializer + ",\n isInScope=" + this.isInScope + ",\n useWriter=" + this.useWriter + ",\n listeners=" + this.listeners + '}';
    }

    public AtmosphereResourceImpl disableSuspend(boolean disableSuspend) {
        this.disableSuspend = disableSuspend;
        return this;
    }

    @Override
    public HttpSession session(boolean create) {
        if (this.session == null) {
            this.session = this.req.getSession(create);
        }
        return this.session;
    }

    @Override
    public AtmosphereResource padding(String padding) {
        this.padding = padding;
        return this;
    }

    @Override
    public HttpSession session() {
        return this.session(true);
    }

    public AtmosphereResourceImpl session(HttpSession session) {
        this.session = session;
        return this;
    }

    public AtmosphereResourceImpl cloneState(AtmosphereResource r) {
        for (AtmosphereResourceEventListener l : ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).atmosphereResourceEventListener()) {
            this.addEventListener(l);
        }
        ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).session(r.session());
        this.setBroadcaster(r.getBroadcaster());
        this.atmosphereHandler(r.getAtmosphereHandler());
        return this;
    }
}

