/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Collection;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;

public final class AtmosphereResourceFactory {
    private static final AtmosphereResourceFactory factory = new AtmosphereResourceFactory();
    private static final AtmosphereHandler voidAtmosphereHandler = new AbstractReflectorAtmosphereHandler(){

        @Override
        public void onRequest(AtmosphereResource resource) throws IOException {
        }

        @Override
        public void destroy() {
        }
    };

    public final AtmosphereResource create(AtmosphereConfig config, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a) {
        return new AtmosphereResourceImpl(config, null, request, response, a, voidAtmosphereHandler);
    }

    public final AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler) {
        return new AtmosphereResourceImpl(config, broadcaster, request, response, a, handler);
    }

    public final AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler) {
        return this.create(config, broadcaster, response.request(), response, a, handler);
    }

    public final AtmosphereResource create(AtmosphereConfig config, AtmosphereResponse response, AsyncSupport<?> a) {
        return new AtmosphereResourceImpl(config, null, response.request(), response, a, voidAtmosphereHandler);
    }

    public final AtmosphereResource remove(String uuid) {
        AtmosphereResource r = this.find(uuid);
        if (r != null) {
            BroadcasterFactory.getDefault().removeAllAtmosphereResource(r);
        }
        return r;
    }

    public final AtmosphereResource find(String uuid) {
        Collection<Broadcaster> l = BroadcasterFactory.getDefault().lookupAll();
        for (Broadcaster b : l) {
            for (AtmosphereResource r : b.getAtmosphereResources()) {
                if (!r.uuid().equalsIgnoreCase(uuid)) continue;
                return r;
            }
        }
        return null;
    }

    public static final AtmosphereResourceFactory getDefault() {
        return factory;
    }
}

