/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.atmosphere.container.version.TomcatWebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatWebSocketHandler
extends MessageInbound {
    private static final Logger logger = LoggerFactory.getLogger(TomcatWebSocketHandler.class);
    private WebSocketProcessor webSocketProcessor;
    private final AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private final WebSocketProtocol webSocketProtocol;

    public TomcatWebSocketHandler(AtmosphereRequest request, AtmosphereFramework framework, WebSocketProtocol webSocketProtocol) {
        this.request = request;
        this.framework = framework;
        this.webSocketProtocol = webSocketProtocol;
    }

    protected void onOpen(WsOutbound outbound) {
        logger.trace("WebSocket.onOpen.");
        try {
            this.webSocketProcessor = WebSocketProcessorFactory.getDefault().newWebSocketProcessor(new TomcatWebSocket(outbound, this.framework.getAtmosphereConfig()));
            this.webSocketProcessor.open(this.request);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    protected void onClose(int closeCode) {
        this.request.destroy();
        if (this.webSocketProcessor == null) {
            return;
        }
        this.webSocketProcessor.close(closeCode);
    }

    protected void onBinaryMessage(ByteBuffer message) throws IOException {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(message.array(), 0, message.limit());
    }

    protected void onTextMessage(CharBuffer message) throws IOException {
        logger.trace("WebSocket.onMessage");
        this.webSocketProcessor.invokeWebSocketProtocol(message.toString());
    }
}

