/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.Set;
import java.util.concurrent.Future;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBroadcaster
extends DefaultBroadcaster {
    private static final Logger logger = LoggerFactory.getLogger(SimpleBroadcaster.class);

    public SimpleBroadcaster(String id, AtmosphereConfig config) {
        super(id, config);
    }

    @Override
    protected BroadcasterConfig createBroadcasterConfig(AtmosphereConfig config) {
        return new BroadcasterConfig(config.framework().broadcasterFilters(), config, false, this.getID()).setScheduledExecutorService(ExecutorsFactory.getScheduler(config));
    }

    @Override
    protected void start() {
        if (!this.started.getAndSet(true)) {
            this.setID(this.name);
        }
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
        bc.setExecutorService(null, false).setAsyncWriteService(null, false).setScheduledExecutorService(ExecutorsFactory.getScheduler(this.config));
    }

    @Override
    public <T> Future<T> broadcast(T msg) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used");
            return null;
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg, this);
        this.futureDone(f);
        this.push(new DefaultBroadcaster.Entry(newMsg, null, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcast(T msg, AtmosphereResource r) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used");
            return null;
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg, this);
        this.futureDone(f);
        this.push(new DefaultBroadcaster.Entry(newMsg, (Object)r, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcast(T msg, Set<AtmosphereResource> subset) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used");
            return null;
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg, this);
        this.futureDone(f);
        this.push(new DefaultBroadcaster.Entry(newMsg, subset, f, msg));
        return f;
    }

    @Override
    protected void prepareInvokeOnStateChange(AtmosphereResource r, AtmosphereResourceEvent e) {
        if (this.writeTimeoutInSecond != -1) {
            logger.warn("{} not supported with this broadcaster.", (Object)ApplicationConfig.WRITE_TIMEOUT);
        }
        this.invokeOnStateChange(r, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueWriteIO(AtmosphereResource r, Object finalMsg, DefaultBroadcaster.Entry entry) throws InterruptedException {
        AtmosphereResource atmosphereResource = r;
        synchronized (atmosphereResource) {
            this.executeAsyncWrite(new DefaultBroadcaster.AsyncWriteToken(r, finalMsg, entry.future, entry.originalMessage, entry.cache));
        }
    }
}

