/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.VoidExecutorService;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebSocketProcessor
implements WebSocketProcessor,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWebSocketProcessor.class);
    private final AtmosphereFramework framework;
    private final WebSocketProtocol webSocketProtocol;
    private final AtomicBoolean loggedMsg = new AtomicBoolean(false);
    private final boolean destroyable;
    private final boolean executeAsync;
    private ExecutorService asyncExecutor;
    private ScheduledExecutorService scheduler;

    public DefaultWebSocketProcessor(AtmosphereFramework framework) {
        this.framework = framework;
        this.webSocketProtocol = framework.getWebSocketProtocol();
        String s = framework.getAtmosphereConfig().getInitParameter(ApplicationConfig.RECYCLE_ATMOSPHERE_REQUEST_RESPONSE);
        this.destroyable = s != null && Boolean.valueOf(s) != false;
        s = framework.getAtmosphereConfig().getInitParameter(ApplicationConfig.WEBSOCKET_PROTOCOL_EXECUTION);
        this.executeAsync = s != null && Boolean.valueOf(s) != false;
        AtmosphereConfig config = framework.getAtmosphereConfig();
        this.asyncExecutor = this.executeAsync ? ExecutorsFactory.getAsyncOperationExecutor(config, "WebSocket") : VoidExecutorService.VOID;
        this.scheduler = ExecutorsFactory.getScheduler(config);
    }

    @Override
    public WebSocketProcessor registerWebSocketHandler(String path, WebSocketHandler webSockethandler) {
        return null;
    }

    @Override
    public final void open(final WebSocket webSocket, AtmosphereRequest request) throws IOException {
        if (!this.loggedMsg.getAndSet(true)) {
            logger.debug("Atmosphere detected WebSocket: {}", (Object)webSocket.getClass().getName());
        }
        AtmosphereResponse wsr = new AtmosphereResponse(webSocket, request, this.destroyable);
        request.headers(DefaultWebSocketProcessor.configureHeader(request)).setAttribute(WebSocket.WEBSOCKET_SUSPEND, true);
        AtmosphereResource r = AtmosphereResourceFactory.getDefault().create(this.framework.getAtmosphereConfig(), wsr, this.framework.getAsyncSupport());
        request.setAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE, r);
        request.setAttribute(ApplicationConfig.SUSPENDED_ATMOSPHERE_RESOURCE_UUID, r.uuid());
        webSocket.resource(r);
        this.webSocketProtocol.onOpen(webSocket);
        this.dispatch(webSocket, request, wsr);
        request.removeAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
        if (webSocket.resource() != null) {
            final AsynchronousProcessor.AsynchronousProcessorHook hook = new AsynchronousProcessor.AsynchronousProcessorHook((AtmosphereResourceImpl)webSocket.resource());
            request.setAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK, hook);
            final Action action = ((AtmosphereResourceImpl)webSocket.resource()).action();
            if (action.timeout() != -1L && !this.framework.getAsyncSupport().getContainerName().contains("Netty")) {
                final AtomicReference f = new AtomicReference();
                f.set(this.scheduler.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        if (WebSocket.class.isAssignableFrom(webSocket.getClass()) && System.currentTimeMillis() - ((WebSocket)WebSocket.class.cast(webSocket)).lastWriteTimeStampInMilliseconds() > action.timeout()) {
                            hook.timedOut();
                            ((Future)f.get()).cancel(true);
                        }
                    }
                }, action.timeout(), action.timeout(), TimeUnit.MILLISECONDS));
            }
        } else {
            logger.warn("AtmosphereResource was null");
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CONNECT, webSocket));
    }

    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, String webSocketMessage) {
        List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(webSocket, webSocketMessage);
        this.dispatch(webSocket, list);
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent(webSocketMessage, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
    }

    private void dispatch(final WebSocket webSocket, List<AtmosphereRequest> list) {
        if (list == null) {
            return;
        }
        for (final AtmosphereRequest r : list) {
            if (r == null) continue;
            boolean b = r.dispatchRequestAsynchronously();
            this.asyncExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtmosphereResponse w = new AtmosphereResponse(webSocket, r, DefaultWebSocketProcessor.this.destroyable);
                    try {
                        DefaultWebSocketProcessor.this.dispatch(webSocket, r, w);
                    }
                    finally {
                        r.destroy();
                        w.destroy();
                    }
                }
            });
        }
    }

    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, byte[] data, int offset, int length) {
        List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(webSocket, data, offset, length);
        this.dispatch(webSocket, list);
        try {
            this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public final void dispatch(WebSocket webSocket, AtmosphereRequest request, AtmosphereResponse r) {
        if (request == null) {
            return;
        }
        try {
            request.setAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity", System.currentTimeMillis());
            this.framework.doCometSupport(request, r);
        }
        catch (Throwable e) {
            logger.warn("Failed invoking AtmosphereFramework.doCometSupport()", e);
            this.webSocketProtocol.onError(webSocket, new WebSocketProcessor.WebSocketException(e, new AtmosphereResponse.Builder().request(request).status(500).statusMessage("Server Error").build()));
            return;
        }
        if (r.getStatus() >= 400) {
            this.webSocketProtocol.onError(webSocket, new WebSocketProcessor.WebSocketException("Status code higher or equal than 400", r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(WebSocket webSocket, int closeCode) {
        block14: {
            logger.trace("WebSocket closed with {}", (Object)closeCode);
            this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CLOSE, webSocket));
            AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
            if (resource == null) {
                logger.warn("Unable to retrieve AtmosphereResource for {}", (Object)webSocket);
            } else {
                AtmosphereRequest r = resource.getRequest(false);
                AtmosphereResponse s = resource.getResponse(false);
                try {
                    this.webSocketProtocol.onClose(webSocket);
                    if (resource == null || !resource.isInScope()) break block14;
                    AsynchronousProcessor.AsynchronousProcessorHook h = (AsynchronousProcessor.AsynchronousProcessorHook)r.getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK);
                    if (h != null) {
                        if (closeCode == 1005) {
                            h.timedOut();
                        } else {
                            h.closed();
                        }
                    } else {
                        logger.warn("AsynchronousProcessor.AsynchronousProcessorHook was null");
                    }
                    resource.setIsInScope(false);
                    try {
                        resource.cancel();
                    }
                    catch (IOException e) {
                        logger.trace("", (Throwable)e);
                    }
                    AsynchronousProcessor.destroyResource(resource);
                }
                finally {
                    if (r != null) {
                        r.destroy(true);
                    }
                    if (s != null) {
                        s.destroy(true);
                    }
                    if (webSocket != null) {
                        webSocket.resource(null);
                    }
                }
            }
        }
    }

    @Override
    public void destroy() {
        boolean shared = this.framework.isShareExecutorServices();
        if (this.asyncExecutor != null && !shared) {
            this.asyncExecutor.shutdown();
        }
        if (this.scheduler != null && !shared) {
            this.scheduler.shutdown();
        }
    }

    @Override
    public void notifyListener(WebSocket webSocket, WebSocketEventListener.WebSocketEvent event) {
        if (webSocket == null) {
            return;
        }
        AtmosphereResource resource = webSocket.resource();
        if (resource == null) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource);
        for (AtmosphereResourceEventListener l : r.atmosphereResourceEventListener()) {
            if (!WebSocketEventListener.class.isAssignableFrom(l.getClass())) continue;
            try {
                switch (event.type()) {
                    case CONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onConnect(event);
                        break;
                    }
                    case DISCONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                        break;
                    }
                    case CONTROL: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onControl(event);
                        break;
                    }
                    case MESSAGE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onMessage(event);
                        break;
                    }
                    case HANDSHAKE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onHandshake(event);
                        break;
                    }
                    case CLOSE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onClose(event);
                    }
                }
            }
            catch (Throwable t) {
                logger.debug("Listener error {}", t);
                try {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onThrowable(new AtmosphereResourceEventImpl(r, false, false, t));
                }
                catch (Throwable t2) {
                    logger.warn("Listener error {}", t2);
                }
            }
        }
    }

    public static final Map<String, String> configureHeader(AtmosphereRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration<String> e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            headers.put(s, request.getParameter(s));
        }
        headers.put("X-Atmosphere-Transport", "websocket");
        return headers;
    }
}

