/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.ArrayList;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereInterceptorWriter
extends AsyncIOWriterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereInterceptorWriter.class);
    private final AtmosphereResponse response;
    private final ArrayList<AsyncIOInterceptor> filters = new ArrayList();

    public AtmosphereInterceptorWriter(AtmosphereResponse response) {
        this.response = response;
    }

    @Override
    public AsyncIOWriter redirect(String location) throws IOException {
        this.response.sendRedirect(location);
        return this;
    }

    @Override
    public AsyncIOWriter writeError(int errorCode, String message) throws IOException {
        this.response.sendError(errorCode);
        return this;
    }

    @Override
    public AsyncIOWriter write(String data) throws IOException {
        for (AsyncIOInterceptor i : this.filters) {
            i.intercept(this.response, data);
        }
        return this;
    }

    @Override
    public AsyncIOWriter write(byte[] data) throws IOException {
        for (AsyncIOInterceptor i : this.filters) {
            i.intercept(this.response, data);
        }
        return this;
    }

    @Override
    public AsyncIOWriter write(byte[] data, int offset, int length) throws IOException {
        for (AsyncIOInterceptor i : this.filters) {
            i.intercept(this.response, data, offset, length);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.response.closeStreamOrWriter();
    }

    @Override
    public AsyncIOWriter flush() throws IOException {
        this.response.flushBuffer();
        return this;
    }

    public AtmosphereInterceptorWriter interceptor(AsyncIOInterceptor filter) {
        this.filters.add(filter);
        return this;
    }
}

