/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidAtmosphereInterceptor
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AndroidAtmosphereInterceptor.class);
    private static final byte[] padding;
    private static final String paddingText;

    @Override
    public void configure(AtmosphereConfig config) {
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        final AtmosphereResponse response = r.getResponse();
        String userAgent = r.getRequest().getHeader("User-Agent");
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING) && userAgent != null && (userAgent.indexOf("Android 2.") != -1 || userAgent.indexOf("Android 3.") != -1)) {
            r.padding("whitespace");
            response.asyncIOWriter(new AsyncIOWriterAdapter(){

                @Override
                public AsyncIOWriter redirect(String location) throws IOException {
                    response.sendRedirect(location);
                    return this;
                }

                @Override
                public AsyncIOWriter writeError(int errorCode, String message) throws IOException {
                    response.sendError(errorCode);
                    return this;
                }

                @Override
                public AsyncIOWriter write(String data) throws IOException {
                    response.write(paddingText).write(data);
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data) throws IOException {
                    response.write(padding).write(data);
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data, int offset, int length) throws IOException {
                    response.write(padding).write(data, offset, length);
                    return this;
                }

                @Override
                public void close() throws IOException {
                    response.closeStreamOrWriter();
                }

                @Override
                public AsyncIOWriter flush() throws IOException {
                    response.flushBuffer();
                    return this;
                }
            });
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public String toString() {
        return "Android Interceptor Support";
    }

    static {
        StringBuffer whitespace = new StringBuffer();
        for (int i = 0; i < 4096; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        paddingText = whitespace.toString();
        padding = paddingText.getBytes();
    }
}

