/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.jboss.servlet.http.HttpEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBossWebCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JBossWebCometSupport.class);
    public static final String HTTP_EVENT = "HttpEvent";
    private static final IllegalStateException unableToDetectComet = new IllegalStateException(JBossWebCometSupport.unableToDetectComet());
    private final ConcurrentLinkedQueue<HttpEvent> resumed = new ConcurrentLinkedQueue();

    public JBossWebCometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereFramework.Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        AtmosphereFramework.Action action;
        block22: {
            HttpEvent event = (HttpEvent)req.getAttribute(HTTP_EVENT);
            if (event == null) {
                throw unableToDetectComet;
            }
            action = null;
            if (event.getType() == HttpEvent.EventType.BEGIN) {
                action = this.suspended(req, res);
                if (action.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
                    logger.debug("Suspending response: {}", (Object)res);
                    try {
                        if (action.timeout != -1L) {
                            event.setTimeout((int)action.timeout);
                            break block22;
                        }
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    catch (UnsupportedOperationException ex) {}
                } else if (action.type == AtmosphereFramework.Action.TYPE.RESUME) {
                    logger.debug("Resuming response: {}", (Object)res);
                    event.close();
                } else {
                    event.close();
                }
            } else if (event.getType() != HttpEvent.EventType.READ) {
                if (event.getType() == HttpEvent.EventType.EOF) {
                    logger.debug("Client closed connection: response: {}", (Object)res);
                    if (!this.resumed.remove(event)) {
                        logger.debug("Client closed connection: response: {}", (Object)res);
                        action = this.cancelled(req, res);
                    } else {
                        logger.debug("Cancelling response: {}", (Object)res);
                    }
                    event.close();
                } else if (event.getType() == HttpEvent.EventType.ERROR) {
                    event.close();
                } else if (event.getType() == HttpEvent.EventType.END) {
                    if (!this.resumed.remove(event)) {
                        logger.debug("Client closed connection response: {}", (Object)res);
                        action = this.cancelled(req, res);
                    } else {
                        logger.debug("Cancelling response: {}", (Object)res);
                    }
                    event.close();
                } else if (event.getType() == HttpEvent.EventType.TIMEOUT) {
                    logger.debug("Timing out {}", (Object)res);
                    action = this.timedout(req, res);
                    event.close();
                }
            }
        }
        return action;
    }

    @Override
    public AtmosphereFramework.Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        AtmosphereFramework.Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)Long.class.cast(req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity")) == -1L) {
            HttpEvent event = (HttpEvent)req.getAttribute(HTTP_EVENT);
            if (event == null) {
                return action;
            }
            this.resumed.offer(event);
            event.close();
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.action().type == AtmosphereFramework.Action.TYPE.RESUME && actionEvent.isInScope()) {
            try {
                HttpEvent event = (HttpEvent)actionEvent.getRequest().getAttribute(HTTP_EVENT);
                this.resumed.offer(event);
                if (this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive") == null || this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive").equalsIgnoreCase("false")) {
                    event.close();
                }
            }
            catch (IOException ex) {
                logger.debug("", (Throwable)ex);
            }
        }
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("JBoss failed to detect this is a Comet application because the APR Connector is not enabled. ");
        sb.append("\nMake sure atmosphere-compat-jboss.jar is not under your WEB-INF/lib and ");
        sb.append("\nthere is no context.xml under WEB-INF");
        return sb.toString();
    }
}

