/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.JettyWebSocketHandler;
import org.atmosphere.container.Tomcat7CometSupport;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.di.ServletContextProvider;
import org.eclipse.jetty.websocket.WebSocket;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class AtmosphereServlet
extends AbstractAsyncServlet
implements org.apache.catalina.CometProcessor,
HttpEventServlet,
ServletContextProvider,
CometProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    protected AtmosphereFramework framework;

    public AtmosphereServlet() {
        this(false);
    }

    public AtmosphereServlet(boolean isFilter) {
        this(isFilter, true);
    }

    public AtmosphereServlet(boolean isFilter, boolean autoDetectHandlers) {
        this.framework = new AtmosphereFramework(isFilter, autoDetectHandlers);
    }

    public void destroy() {
        this.framework.destroy();
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.framework.init(sc);
    }

    public AtmosphereFramework framework() {
        return this.framework;
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.framework.doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(org.apache.catalina.CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest req = cometEvent.getHttpServletRequest();
        HttpServletResponse res = cometEvent.getHttpServletResponse();
        req.setAttribute("CometEvent", (Object)cometEvent);
        if (!this.framework.isCometSupportSpecified && !this.framework.isCometSupportConfigured.getAndSet(true)) {
            AsyncSupport asyncSupport = this.framework.asyncSupport;
            synchronized (asyncSupport) {
                if (!this.framework.asyncSupport.getClass().equals(TomcatCometSupport.class)) {
                    logger.warn("TomcatCometSupport is enabled, switching to it");
                    this.framework.asyncSupport = new TomcatCometSupport(this.framework.config);
                }
            }
        }
        this.framework.doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest req = cometEvent.getHttpServletRequest();
        HttpServletResponse res = cometEvent.getHttpServletResponse();
        req.setAttribute("CometEvent", (Object)cometEvent);
        if (!this.framework.isCometSupportSpecified && !this.framework.isCometSupportConfigured.getAndSet(true)) {
            AsyncSupport asyncSupport = this.framework.asyncSupport;
            synchronized (asyncSupport) {
                if (!this.framework.asyncSupport.getClass().equals(Tomcat7CometSupport.class)) {
                    logger.warn("TomcatCometSupport is enabled, switching to it");
                    this.framework.asyncSupport = new Tomcat7CometSupport(this.framework.config);
                }
            }
        }
        this.framework.doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(HttpEvent httpEvent) throws IOException, ServletException {
        HttpServletRequest req = httpEvent.getHttpServletRequest();
        HttpServletResponse res = httpEvent.getHttpServletResponse();
        req.setAttribute("HttpEvent", (Object)httpEvent);
        if (!this.framework.isCometSupportSpecified && !this.framework.isCometSupportConfigured.getAndSet(true)) {
            AsyncSupport asyncSupport = this.framework.asyncSupport;
            synchronized (asyncSupport) {
                if (!this.framework.asyncSupport.getClass().equals(JBossWebCometSupport.class)) {
                    logger.warn("JBossWebCometSupport is enabled, switching to it");
                    this.framework.asyncSupport = new JBossWebCometSupport(this.framework.config);
                }
            }
        }
        this.framework.doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
    }

    protected boolean doRequest(RequestResponseKey rrk) throws IOException, ServletException {
        try {
            rrk.getRequest().getSession().setAttribute("RequestResponseKey", (Object)rrk);
            AtmosphereFramework.Action action = this.framework.doCometSupport(AtmosphereRequest.wrap(rrk.getRequest()), AtmosphereResponse.wrap(rrk.getResponse()));
            if (action.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
                if (action.timeout == -1L) {
                    rrk.setTimeout(Integer.MAX_VALUE);
                } else {
                    rrk.setTimeout((int)action.timeout);
                }
            }
            return action.type == AtmosphereFramework.Action.TYPE.SUSPEND;
        }
        catch (IllegalStateException ex) {
            logger.error("AtmosphereServlet.doRequest exception", (Throwable)ex);
            throw ex;
        }
    }

    protected void doResponse(RequestResponseKey rrk, Object context) throws IOException, ServletException {
        rrk.getResponse().flushBuffer();
    }

    protected void doTimeout(RequestResponseKey rrk) throws IOException, ServletException {
        ((AsynchronousProcessor)this.framework.asyncSupport).timedout(AtmosphereRequest.wrap(rrk.getRequest()), AtmosphereResponse.wrap(rrk.getResponse()));
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        logger.debug("WebSocket upgrade requested");
        request.setAttribute(org.atmosphere.websocket.WebSocket.WEBSOCKET_INITIATED, (Object)true);
        return new JettyWebSocketHandler(AtmosphereRequest.wrap(request), this.framework, this.framework.webSocketProtocol);
    }
}

