/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.atmosphere.container.version.Jetty8WebSocket;
import org.atmosphere.container.version.JettyWebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.util.FakeHttpSession;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketHandler
implements WebSocket,
WebSocket.OnFrame,
WebSocket.OnBinaryMessage,
WebSocket.OnTextMessage,
WebSocket.OnControl {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketHandler.class);
    private WebSocketProcessor webSocketProcessor;
    private final JettyRequestFix request;
    private final AtmosphereFramework framework;
    private WebSocketProtocol webSocketProtocol;

    public JettyWebSocketHandler(AtmosphereRequest request, AtmosphereFramework framework, WebSocketProtocol webSocketProtocol) {
        this.request = new JettyRequestFix(request);
        this.framework = framework;
        this.webSocketProtocol = webSocketProtocol;
    }

    public void onConnect(WebSocket.Outbound outbound) {
        logger.debug("WebSocket.onConnect (outbound)");
        try {
            this.webSocketProcessor = new WebSocketProcessor(this.framework, new JettyWebSocket(outbound), this.webSocketProtocol);
            this.webSocketProcessor.dispatch(AtmosphereRequest.wrap((HttpServletRequest)this.request));
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public void onMessage(byte frame, String data) {
        logger.trace("WebSocket.onMessage (frame/string)");
        this.webSocketProcessor.invokeWebSocketProtocol(data);
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(data, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
    }

    public void onMessage(byte frame, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onMessage (frame)");
        this.webSocketProcessor.invokeWebSocketProtocol(new String(data, offset, length));
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public void onFragment(boolean more, byte opcode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onFragment");
        this.webSocketProcessor.invokeWebSocketProtocol(new String(data, offset, length));
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public void onDisconnect() {
        this.request.destroy();
        logger.trace("WebSocket.onDisconnect");
        this.webSocketProcessor.close(1000);
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.DISCONNECT, this.webSocketProcessor.webSocket()));
    }

    public void onMessage(byte[] data, int offset, int length) {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(data, offset, length);
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onControl.");
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.CONTROL, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
        return false;
    }

    public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onFrame.");
        return false;
    }

    public void onHandshake(WebSocket.FrameConnection connection) {
        logger.trace("WebSocket.onHandshake");
        try {
            this.webSocketProcessor = new WebSocketProcessor(this.framework, new Jetty8WebSocket((WebSocket.Connection)connection, this.framework.getAtmosphereConfig()), this.webSocketProtocol);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.HANDSHAKE, this.webSocketProcessor.webSocket()));
    }

    public void onMessage(String data) {
        logger.trace("WebSocket.onMessage");
        this.webSocketProcessor.invokeWebSocketProtocol(data);
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(data, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
    }

    public void onOpen(WebSocket.Connection connection) {
        logger.trace("WebSocket.onOpen.");
        try {
            this.webSocketProcessor = new WebSocketProcessor(this.framework, new Jetty8WebSocket(connection, this.framework.getAtmosphereConfig()), this.webSocketProtocol);
            this.webSocketProcessor.dispatch(AtmosphereRequest.wrap((HttpServletRequest)this.request));
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CONNECT, this.webSocketProcessor.webSocket()));
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public void onClose(int closeCode, String message) {
        this.request.destroy();
        if (this.webSocketProcessor == null) {
            return;
        }
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CLOSE, this.webSocketProcessor.webSocket()));
        this.webSocketProcessor.close(closeCode);
    }

    private static class JettyRequestFix
    extends HttpServletRequestWrapper {
        private final String contextPath;
        private final String servletPath;
        private final String pathInfo;
        private final String requestUri;
        private final FakeHttpSession httpSession;
        private final StringBuffer requestURL;
        private final HashMap<String, Object> attributes = new HashMap();
        private final HashMap<String, String> headers = new HashMap();
        private final HashMap<String, String[]> parameters = new HashMap();
        private final String method;
        private final String serverName;
        private final int serverPort;

        public JettyRequestFix(AtmosphereRequest request) {
            super((HttpServletRequest)request);
            String s;
            this.servletPath = request.getServletPath();
            this.contextPath = request.getContextPath();
            this.pathInfo = request.getPathInfo();
            this.requestUri = request.getRequestURI();
            this.requestURL = request.getRequestURL();
            this.method = request.getMethod();
            this.serverName = request.getServerName();
            this.serverPort = request.getServerPort();
            HttpSession session = request.getSession(true);
            this.httpSession = new FakeHttpSession(session);
            Enumeration<String> e = request.getHeaderNames();
            while (e.hasMoreElements()) {
                s = e.nextElement();
                this.headers.put(s, request.getHeader(s));
            }
            e = request.getAttributeNames();
            while (e.hasMoreElements()) {
                s = e.nextElement();
                this.attributes.put(s, request.getAttribute(s));
            }
            e = request.getParameterNames();
            while (e.hasMoreElements()) {
                s = e.nextElement();
                this.parameters.put(s, request.getParameterValues(s));
            }
        }

        public void destroy() {
            this.attributes.clear();
            this.headers.clear();
            this.parameters.clear();
            this.httpSession.destroy();
        }

        public String getServerName() {
            return this.serverName;
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public HttpSession getSession(boolean create) {
            return this.httpSession;
        }

        public String getMethod() {
            return this.method;
        }

        public String getHeader(String name) {
            return this.headers.get(name);
        }

        public Enumeration<String> getHeaders(final String name) {
            return new Enumeration<String>(){
                boolean hasNext = true;

                @Override
                public boolean hasMoreElements() {
                    return this.hasNext && JettyRequestFix.this.headers.get(name) != null;
                }

                @Override
                public String nextElement() {
                    this.hasNext = false;
                    return (String)JettyRequestFix.this.headers.get(name);
                }
            };
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.parameters.keySet());
        }

        public String getParameter(String name) {
            return this.parameters.get(name) != null ? this.parameters.get(name)[0] : null;
        }

        public String[] getParameterValues(String name) {
            return this.parameters.get(name);
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.attributes.keySet());
        }

        public void setAttribute(String name, Object o) {
            this.attributes.put(name, o);
        }

        public void removeAttribute(String name) {
            this.attributes.remove(name);
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getRequestURI() {
            return this.requestUri;
        }

        public HttpSession getSession() {
            return this.httpSession;
        }

        public StringBuffer getRequestURL() {
            return this.requestURL;
        }
    }
}

