/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.container.JettyWebSocketUtil;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet30CometSupportWithWebSocket
extends Servlet30CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(Servlet30CometSupportWithWebSocket.class);
    private final WebSocketFactory webSocketFactory;

    public Servlet30CometSupportWithWebSocket(AtmosphereConfig config) {
        super(config);
        boolean isJetty = config.getServletContext().getServerInfo().toLowerCase().startsWith("jetty");
        this.webSocketFactory = isJetty ? JettyWebSocketUtil.getFactory(config) : null;
    }

    @Override
    public AtmosphereFramework.Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        AtmosphereFramework.Action action = JettyWebSocketUtil.doService(this, req, res, this.webSocketFactory);
        return action == null ? super.service(req, res) : action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

