/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHandshakeFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHandshakeFilter.class);
    private String[] bannedVersion;

    public void init(FilterConfig filterConfig) throws ServletException {
        String draft = filterConfig.getInitParameter("org.atmosphere.websocket.bannedVersion");
        if (draft != null) {
            this.bannedVersion = draft.split(",");
            logger.debug("Blocked WebSocket Draft version {}", (Object)draft);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (((HttpServletRequest)HttpServletRequest.class.cast(request)).getHeader("Upgrade") != null) {
            int draft = ((HttpServletRequest)HttpServletRequest.class.cast(request)).getIntHeader("Sec-WebSocket-Version");
            if (draft < 0) {
                draft = ((HttpServletRequest)HttpServletRequest.class.cast(request)).getIntHeader("Sec-WebSocket-Draft");
            }
            if (this.bannedVersion != null) {
                for (String s : this.bannedVersion) {
                    if (Integer.getInteger(s) != draft) continue;
                    ((HttpServletResponse)HttpServletResponse.class.cast(response)).addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                    ((HttpServletResponse)HttpServletResponse.class.cast(response)).sendError(202, "Websocket protocol not supported");
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

