/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.JettyWebSocketHandler;
import org.atmosphere.container.Tomcat7CometSupport;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.CometSupportResolver;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.DefaultCometSupportResolver;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.di.InjectorProvider;
import org.atmosphere.di.ServletContextHolder;
import org.atmosphere.di.ServletContextProvider;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.AtmosphereConfigReader;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.Version;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class AtmosphereServlet
extends AbstractAsyncServlet
implements org.apache.catalina.CometProcessor,
HttpEventServlet,
ServletContextProvider,
CometProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    private final ArrayList<String> possibleAtmosphereHandlersCandidate = new ArrayList();
    private final HashMap<String, String> initParams = new HashMap();
    protected final AtmosphereConfig config = new AtmosphereConfig();
    protected final AtomicBoolean isCometSupportConfigured = new AtomicBoolean(false);
    protected final boolean isFilter;
    public static String[] broadcasterFilters = new String[0];
    protected final Map<String, AtmosphereHandlerWrapper> atmosphereHandlers = new ConcurrentHashMap<String, AtmosphereHandlerWrapper>();
    private final ConcurrentLinkedQueue<String> broadcasterTypes = new ConcurrentLinkedQueue();
    protected boolean useNativeImplementation = false;
    protected boolean useBlockingImplementation = false;
    protected boolean useStreamForFlushingComments = false;
    protected CometSupport cometSupport;
    protected static String broadcasterClassName = DefaultBroadcaster.class.getName();
    protected boolean isCometSupportSpecified = false;
    protected boolean isBroadcasterSpecified = false;
    protected boolean isSessionSupportSpecified = false;
    private BroadcasterFactory broadcasterFactory;
    protected String broadcasterFactoryClassName;
    protected static String broadcasterCacheClassName;
    private boolean webSocketEnabled = true;
    private String broadcasterLifeCyclePolicy = "NEVER";
    private String webSocketProtocolClassName = SimpleHttpProtocol.class.getName();
    private WebSocketProtocol webSocketProtocol;

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public AtmosphereServlet() {
        this(false);
    }

    public AtmosphereServlet(boolean isFilter) {
        this.isFilter = isFilter;
        this.readSystemProperties();
        this.populateBroadcasterType();
    }

    private void populateBroadcasterType() {
        this.broadcasterTypes.add("org.atmosphere.plugin.xmpp.XMPPBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.redis.RedisBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jgroups.JGroupsBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jms.JMSBroadcaster");
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h, mapping);
        this.addMapping(mapping, w);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
    }

    private void addMapping(String path, AtmosphereHandlerWrapper w) {
        this.atmosphereHandlers.put(path, w);
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h, mapping);
        w.broadcaster.setID(broadcasterId);
        this.addMapping(mapping, w);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler<HttpServletRequest, HttpServletResponse> h, Broadcaster broadcaster) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h, broadcaster);
        this.addMapping(mapping, w);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
    }

    public boolean removeAtmosphereHandler(String mapping) {
        return this.atmosphereHandlers.remove(mapping) != null;
    }

    public void removeAllAtmosphereHandler() {
        this.atmosphereHandlers.clear();
    }

    public void removeAllInitParams() {
        this.initParams.clear();
    }

    public void addInitParameter(String name, String value) {
        this.initParams.put(name, value);
    }

    protected void readSystemProperties() {
        if (System.getProperty("org.atmosphere.useNative") != null) {
            this.useNativeImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useNative"));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty("org.atmosphere.useBlocking") != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useBlocking"));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty("org.atmosphere.disableOnStateEvent") != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", System.getProperty("org.atmosphere.disableOnStateEvent"));
        }
    }

    public void init(final ServletConfig sc) throws ServletException {
        try {
            super.init(sc);
            ServletContextHolder.register(this);
            ServletConfig scFacade = new ServletConfig(){

                public String getServletName() {
                    return sc.getServletName();
                }

                public ServletContext getServletContext() {
                    return sc.getServletContext();
                }

                public String getInitParameter(String name) {
                    String param = sc.getInitParameter(name);
                    if (param == null) {
                        return (String)AtmosphereServlet.this.initParams.get(name);
                    }
                    return param;
                }

                public Enumeration<String> getInitParameterNames() {
                    return sc.getInitParameterNames();
                }
            };
            this.doInitParams(scFacade);
            this.doInitParamsForWebSocket(scFacade);
            this.configureBroadcaster(sc.getServletContext());
            this.loadConfiguration(scFacade);
            this.autoDetectContainer();
            this.configureWebDotXmlAtmosphereHandler(sc);
            this.cometSupport.init(scFacade);
            this.initAtmosphereHandler(scFacade);
            this.initWebSocketProtocol();
            logger.info("Using broadcaster class: {}", (Object)broadcasterClassName);
            logger.info("Atmosphere Framework {} started.", (Object)Version.getRawVersion());
        }
        catch (Throwable t) {
            logger.error("failed to initialize atmosphere framework", t);
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t.getCause());
        }
    }

    protected void configureWebDotXmlAtmosphereHandler(ServletConfig sc) {
        String s = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_HANDLER);
        if (s != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                String mapping = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_HANDLER_MAPPING);
                if (mapping == null) {
                    mapping = "/*";
                }
                this.addAtmosphereHandler(mapping, (AtmosphereHandler)cl.loadClass(s).newInstance());
            }
            catch (Exception ex) {
                logger.warn("Unable to load WebSocketHandle instance", (Throwable)ex);
            }
        }
    }

    protected void configureBroadcaster(ServletContext sc) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.broadcasterFactoryClassName != null) {
            this.broadcasterFactory = (BroadcasterFactory)Thread.currentThread().getContextClassLoader().loadClass(this.broadcasterFactoryClassName).newInstance();
        }
        if (this.broadcasterFactory == null) {
            Class<?> bc = Thread.currentThread().getContextClassLoader().loadClass(broadcasterClassName);
            logger.info("Using BroadcasterFactory class: {}", (Object)DefaultBroadcasterFactory.class.getName());
            this.broadcasterFactory = new DefaultBroadcasterFactory(bc, this.broadcasterLifeCyclePolicy, this.config);
        }
        if (sc != null) {
            sc.setAttribute(BroadcasterFactory.class.getName(), (Object)this.broadcasterFactory);
        }
        this.config.broadcasterFactory = this.broadcasterFactory;
        BroadcasterFactory.setBroadcasterFactory(this.broadcasterFactory, this.config);
        InjectorProvider.getInjector().inject(this.broadcasterFactory);
        for (Map.Entry<String, AtmosphereHandlerWrapper> e : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper w = e.getValue();
            BroadcasterConfig broadcasterConfig = new BroadcasterConfig(broadcasterFilters, this.config);
            if (w.broadcaster == null) {
                w.broadcaster = this.broadcasterFactory.get(w.mapping);
                continue;
            }
            w.broadcaster.setBroadcasterConfig(broadcasterConfig);
            if (broadcasterCacheClassName == null) continue;
            BroadcasterCache cache = (BroadcasterCache)Thread.currentThread().getContextClassLoader().loadClass(broadcasterCacheClassName).newInstance();
            InjectorProvider.getInjector().inject(cache);
            broadcasterConfig.setBroadcasterCache(cache);
        }
    }

    protected void doInitParamsForWebSocket(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.useWebSocket");
        if (s != null) {
            this.webSocketEnabled = Boolean.parseBoolean(s);
            this.sessionSupport(false);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.WEBSOCKET_PROTOCOL)) != null) {
            this.webSocketProtocolClassName = s;
        }
    }

    protected void doInitParams(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.useNative");
        if (s != null) {
            this.useNativeImplementation = Boolean.parseBoolean(s);
            if (this.useNativeImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useBlocking")) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(s);
            if (this.useBlockingImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useStream")) != null) {
            this.useStreamForFlushingComments = Boolean.parseBoolean(s);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.PROPERTY_COMET_SUPPORT)) != null) {
            this.cometSupport = new DefaultCometSupportResolver(this.config).newCometSupport(s);
            this.isCometSupportSpecified = true;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_CLASS)) != null) {
            broadcasterClassName = s;
            this.isBroadcasterSpecified = true;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_CACHE)) != null) {
            broadcasterCacheClassName = s;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.PROPERTY_SESSION_SUPPORT)) != null) {
            this.config.supportSession = Boolean.valueOf(s);
            this.isSessionSupportSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.disableOnStateEvent")) != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", s);
        } else {
            this.initParams.put("org.atmosphere.disableOnStateEvent", "false");
        }
        s = sc.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE);
        if (s != null) {
            this.initParams.put(ApplicationConfig.RESUME_AND_KEEPALIVE, s);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCAST_FILTER_CLASSES)) != null) {
            broadcasterFilters = s.split(",");
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_LIFECYCLE_POLICY)) != null) {
            this.broadcasterLifeCyclePolicy = s;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_FACTORY)) != null) {
            this.broadcasterFactoryClassName = s;
        }
    }

    protected void loadConfiguration(ServletConfig sc) throws ServletException {
        try {
            URL url = sc.getServletContext().getResource("/WEB-INF/classes/");
            URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            this.loadAtmosphereDotXml(sc.getServletContext().getResourceAsStream("/META-INF/atmosphere.xml"), urlC);
            if (this.atmosphereHandlers.size() == 0) {
                this.autoDetectAtmosphereHandlers(sc.getServletContext(), urlC);
                if (this.atmosphereHandlers.size() == 0) {
                    this.detectSupportedFramework(sc);
                }
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected boolean detectSupportedFramework(ServletConfig sc) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String broadcasterClassNameTmp = null;
        try {
            cl.loadClass("com.sun.jersey.spi.container.servlet.ServletContainer");
            if (!this.isBroadcasterSpecified) {
                broadcasterClassNameTmp = this.lookupDefaultBroadcasterType();
                cl.loadClass(broadcasterClassNameTmp);
            }
            this.useStreamForFlushingComments = true;
        }
        catch (Throwable t) {
            logger.trace("", t);
            return false;
        }
        logger.warn("Missing META-INF/atmosphere.xml but found the Jersey runtime. Starting Jersey");
        this.initParams.put(FrameworkConfig.WRITE_HEADERS, "false");
        ReflectorServletProcessor rsp = new ReflectorServletProcessor();
        if (broadcasterClassNameTmp != null) {
            broadcasterClassName = broadcasterClassNameTmp;
        }
        rsp.setServletClassName("com.sun.jersey.spi.container.servlet.ServletContainer");
        this.sessionSupport(false);
        this.initParams.put("org.atmosphere.disableOnStateEvent", "true");
        String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
        if (mapping == null) {
            mapping = "/*";
        }
        Class<?> bc = cl.loadClass(broadcasterClassName);
        this.broadcasterFactory.destroy();
        logger.info("Using BroadcasterFactory class: {}", (Object)DefaultBroadcasterFactory.class.getName());
        this.broadcasterFactory = new DefaultBroadcasterFactory(bc, this.broadcasterLifeCyclePolicy, this.config);
        Broadcaster b = BroadcasterFactory.getDefault().get(bc, mapping);
        this.addAtmosphereHandler(mapping, (AtmosphereHandler<HttpServletRequest, HttpServletResponse>)rsp, b);
        return true;
    }

    protected String lookupDefaultBroadcasterType() {
        for (String b : this.broadcasterTypes) {
            try {
                Class.forName(b);
                return b;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return "org.atmosphere.jersey.JerseyBroadcaster";
    }

    protected void sessionSupport(boolean sessionSupport) {
        if (!this.isSessionSupportSpecified) {
            this.config.supportSession = sessionSupport;
        }
    }

    void initAtmosphereHandler(ServletConfig sc) throws ServletException {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper w = h.getValue();
            AtmosphereHandler a = w.atmosphereHandler;
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).init(sc);
        }
        if (this.atmosphereHandlers.size() == 0 && !this.webSocketProtocolClassName.equalsIgnoreCase(SimpleHttpProtocol.class.getName())) {
            logger.debug("Adding a void AtmosphereHandler mapped to /* to allow WebSocket application only");
            this.addAtmosphereHandler("/*", new AbstractReflectorAtmosphereHandler(){

                @Override
                public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> httpServletRequestHttpServletResponseAtmosphereResource) throws IOException {
                }

                @Override
                public void destroy() {
                }
            });
        }
    }

    protected void initWebSocketProtocol() {
        try {
            this.webSocketProtocol = (WebSocketProtocol)JettyWebSocketHandler.class.getClassLoader().loadClass(this.webSocketProtocolClassName).newInstance();
        }
        catch (Exception ex) {
            logger.error("Cannot load the WebSocketProtocol {}", (Object)this.getWebSocketProtocolClassName(), (Object)ex);
            this.webSocketProtocol = new SimpleHttpProtocol();
        }
        this.webSocketProtocol.configure(this.config);
    }

    public void destroy() {
        if (this.cometSupport != null && AsynchronousProcessor.class.isAssignableFrom(this.cometSupport.getClass())) {
            ((AsynchronousProcessor)this.cometSupport).shutdown();
        }
        Object bc = null;
        for (Map.Entry<String, AtmosphereHandlerWrapper> entry : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper handlerWrapper = entry.getValue();
            handlerWrapper.atmosphereHandler.destroy();
        }
        BroadcasterFactory factory = BroadcasterFactory.getDefault();
        if (factory != null) {
            factory.destroy();
            BroadcasterFactory.factory = null;
        }
    }

    protected void loadAtmosphereDotXml(InputStream stream, URLClassLoader c) throws IOException, ServletException {
        if (stream == null) {
            return;
        }
        AtmosphereConfigReader reader = new AtmosphereConfigReader(stream);
        Map<String, String> atmosphereHandlerNames = reader.getAtmosphereHandlers();
        Set<Map.Entry<String, String>> entries = atmosphereHandlerNames.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String handlerClassName = entry.getValue();
            String handlerPath = entry.getKey();
            try {
                Object bc;
                AtmosphereHandler<HttpServletRequest, HttpServletResponse> handler;
                if (!handlerClassName.equals(ReflectorServletProcessor.class.getName())) {
                    handler = (AtmosphereHandler)c.loadClass(handlerClassName).newInstance();
                    InjectorProvider.getInjector().inject(handler);
                } else {
                    handler = new ReflectorServletProcessor();
                }
                logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)handlerPath);
                boolean isJersey = false;
                for (AtmosphereConfigReader.Property p : reader.getProperty(handlerPath)) {
                    if (p.value != null && p.value.indexOf("jersey") != -1) {
                        isJersey = true;
                        this.initParams.put("org.atmosphere.disableOnStateEvent", "true");
                        this.useStreamForFlushingComments = true;
                        broadcasterClassName = this.lookupDefaultBroadcasterType();
                    }
                    IntrospectionUtils.setProperty(handler, p.name, p.value);
                }
                this.config.supportSession = !isJersey;
                if (!reader.supportSession().equals("")) {
                    this.sessionSupport(Boolean.valueOf(reader.supportSession()));
                }
                for (AtmosphereConfigReader.Property p : reader.getProperty(handlerPath)) {
                    IntrospectionUtils.addProperty(handler, p.name, p.value);
                }
                String broadcasterClass = reader.getBroadcasterClass(handlerPath);
                if (broadcasterClass != null) {
                    broadcasterClassName = broadcasterClass;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    bc = cl.loadClass(broadcasterClassName);
                    this.broadcasterFactory = new DefaultBroadcasterFactory((Class<? extends Broadcaster>)bc, this.broadcasterLifeCyclePolicy, this.config);
                    BroadcasterFactory.setBroadcasterFactory(this.broadcasterFactory, this.config);
                }
                Broadcaster b = BroadcasterFactory.getDefault().get(handlerPath);
                AtmosphereHandlerWrapper wrapper = new AtmosphereHandlerWrapper((AtmosphereHandler)handler, b);
                this.addMapping(handlerPath, wrapper);
                bc = reader.getBroadcasterCache(handlerPath);
                if (bc != null) {
                    broadcasterCacheClassName = bc;
                }
                if (reader.getCometSupportClass() != null) {
                    this.cometSupport = (CometSupport)c.loadClass(reader.getCometSupportClass()).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
                }
                if (reader.getBroadcastFilterClasses() == null) continue;
                broadcasterFilters = reader.getBroadcastFilterClasses();
            }
            catch (Throwable t) {
                logger.warn("unable to load AtmosphereHandler class: " + handlerClassName, t);
                throw new ServletException(t);
            }
        }
    }

    public void setCometSupport(CometSupport cometSupport) {
        this.cometSupport = cometSupport;
    }

    public CometSupport getCometSupport() {
        return this.cometSupport;
    }

    protected CometSupportResolver createCometSupportResolver() {
        return new DefaultCometSupportResolver(this.config);
    }

    protected void autoDetectContainer() {
        if (this.getCometSupport() == null) {
            this.setCometSupport(this.createCometSupportResolver().resolve(this.useNativeImplementation, this.useBlockingImplementation, this.webSocketEnabled));
        }
        logger.info("Atmosphere is using async support: {} running under container: {}", (Object)this.getCometSupport().getClass().getName(), (Object)this.cometSupport.getContainerName());
    }

    protected void autoDetectAtmosphereHandlers(ServletContext servletContext, URLClassLoader classloader) throws MalformedURLException, URISyntaxException {
        logger.info("Auto detecting atmosphere handlers in WEB-INF/classes");
        String realPath = servletContext.getRealPath("/WEB-INF/classes/");
        if (realPath == null) {
            URL u = servletContext.getResource("/WEB-INF/classes/");
            if (u == null) {
                return;
            }
            realPath = u.getPath();
        }
        this.loadAtmosphereHandlersFromPath(classloader, realPath);
    }

    protected void loadAtmosphereHandlersFromPath(URLClassLoader classloader, String realPath) {
        File file = new File(realPath);
        if (file.isDirectory()) {
            this.getFiles(file);
            for (String className : this.possibleAtmosphereHandlersCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!AtmosphereHandler.class.isAssignableFrom(clazz)) continue;
                    AtmosphereHandler handler = (AtmosphereHandler)clazz.newInstance();
                    InjectorProvider.getInjector().inject(handler);
                    this.addMapping("/" + handler.getClass().getSimpleName(), new AtmosphereHandlerWrapper(handler, "/" + handler.getClass().getSimpleName()));
                    logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)handler.getClass().getName());
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an AtmosphereHandler: " + className, t);
                }
            }
        }
    }

    private void getFiles(File f) {
        File[] files;
        for (File test : files = f.listFiles()) {
            if (test.isDirectory()) {
                this.getFiles(test);
                continue;
            }
            String clazz = test.getAbsolutePath();
            if (!clazz.endsWith(".class")) continue;
            this.possibleAtmosphereHandlersCandidate.add(clazz);
        }
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doCometSupport(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action doCometSupport(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        block9: {
            req.setAttribute(ApplicationConfig.BROADCASTER_FACTORY, (Object)this.broadcasterFactory);
            req.setAttribute("org.atmosphere.useStream", (Object)this.useStreamForFlushingComments);
            req.setAttribute(ApplicationConfig.BROADCASTER_CLASS, (Object)broadcasterClassName);
            req.setAttribute(ApplicationConfig.SUPPORT_TRACKABLE, (Object)this.config.getInitParameter(ApplicationConfig.SUPPORT_TRACKABLE));
            req.setAttribute("org.atmosphere.jersey.supportLocationHeader", (Object)this.config.getInitParameter("org.atmosphere.jersey.supportLocationHeader"));
            AtmosphereRequest r = null;
            Action a = null;
            try {
                if (this.config.getInitParameter(ApplicationConfig.ALLOW_QUERYSTRING_AS_REQUEST) != null && (this.isIECandidate(req) || req.getParameter("jsonpTransport") != null) && req.getAttribute(WebSocket.WEBSOCKET_SUSPEND) == null) {
                    Map<String, String> headers = this.configureQueryStringAsRequest(req);
                    String body = headers.remove("X-Atmosphere-Post-Body");
                    r = new AtmosphereRequest.Builder().headers(headers).method(body != null && req.getMethod().equalsIgnoreCase("GET") ? "POST" : req.getMethod()).body(body).request(req).build();
                    a = this.cometSupport.service((HttpServletRequest)r, res);
                    break block9;
                }
                Action headers = this.cometSupport.service(req, res);
                return headers;
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage() != null && ex.getMessage().startsWith("Tomcat failed")) {
                    if (!this.isFilter) {
                        logger.warn("Failed using comet support: {}, error: {} Is the Nio or Apr Connector enabled?", (Object)this.cometSupport.getClass().getName(), (Object)ex.getMessage());
                        logger.warn("Using BlockingIOCometSupport.");
                    }
                    logger.trace(ex.getMessage(), (Throwable)ex);
                    this.cometSupport = new BlockingIOCometSupport(this.config);
                    this.service(req, res);
                    break block9;
                }
                logger.error("AtmosphereServlet exception", (Throwable)ex);
                throw ex;
            }
            finally {
                if (r != null && a != null && a.type != Action.TYPE.SUSPEND) {
                    r.destroy();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(org.apache.catalina.CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest req = cometEvent.getHttpServletRequest();
        HttpServletResponse res = cometEvent.getHttpServletResponse();
        req.setAttribute("CometEvent", (Object)cometEvent);
        if (!this.isCometSupportSpecified && !this.isCometSupportConfigured.getAndSet(true)) {
            CometSupport cometSupport = this.cometSupport;
            synchronized (cometSupport) {
                if (!this.cometSupport.getClass().equals(TomcatCometSupport.class)) {
                    logger.warn("TomcatCometSupport is enabled, switching to it");
                    this.cometSupport = new TomcatCometSupport(this.config);
                }
            }
        }
        this.doCometSupport(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest req = cometEvent.getHttpServletRequest();
        HttpServletResponse res = cometEvent.getHttpServletResponse();
        req.setAttribute("CometEvent", (Object)cometEvent);
        if (!this.isCometSupportSpecified && !this.isCometSupportConfigured.getAndSet(true)) {
            CometSupport cometSupport = this.cometSupport;
            synchronized (cometSupport) {
                if (!this.cometSupport.getClass().equals(Tomcat7CometSupport.class)) {
                    logger.warn("TomcatCometSupport is enabled, switching to it");
                    this.cometSupport = new Tomcat7CometSupport(this.config);
                }
            }
        }
        this.doCometSupport(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(HttpEvent httpEvent) throws IOException, ServletException {
        HttpServletRequest req = httpEvent.getHttpServletRequest();
        HttpServletResponse res = httpEvent.getHttpServletResponse();
        req.setAttribute("HttpEvent", (Object)httpEvent);
        if (!this.isCometSupportSpecified && !this.isCometSupportConfigured.getAndSet(true)) {
            CometSupport cometSupport = this.cometSupport;
            synchronized (cometSupport) {
                if (!this.cometSupport.getClass().equals(JBossWebCometSupport.class)) {
                    logger.warn("JBossWebCometSupport is enabled, switching to it");
                    this.cometSupport = new JBossWebCometSupport(this.config);
                }
            }
        }
        this.doCometSupport(req, res);
    }

    protected boolean doRequest(RequestResponseKey rrk) throws IOException, ServletException {
        try {
            rrk.getRequest().getSession().setAttribute("RequestResponseKey", (Object)rrk);
            Action action = this.doCometSupport(rrk.getRequest(), rrk.getResponse());
            if (action.type == Action.TYPE.SUSPEND) {
                if (action.timeout == -1L) {
                    rrk.setTimeout(Integer.MAX_VALUE);
                } else {
                    rrk.setTimeout((int)action.timeout);
                }
            }
            return action.type == Action.TYPE.SUSPEND;
        }
        catch (IllegalStateException ex) {
            logger.error("AtmosphereServlet.doRequest exception", (Throwable)ex);
            throw ex;
        }
    }

    protected void doResponse(RequestResponseKey rrk, Object context) throws IOException, ServletException {
        rrk.getResponse().flushBuffer();
    }

    protected void doTimeout(RequestResponseKey rrk) throws IOException, ServletException {
        ((AsynchronousProcessor)this.cometSupport).timedout(rrk.getRequest(), rrk.getResponse());
    }

    public static String getDefaultBroadcasterClassName() {
        return broadcasterClassName;
    }

    public static void setDefaultBroadcasterClassName(String bccn) {
        broadcasterClassName = bccn;
    }

    public boolean isUseStreamForFlushingComments() {
        return this.useStreamForFlushingComments;
    }

    public void setUseStreamForFlushingComments(boolean useStreamForFlushingComments) {
        this.useStreamForFlushingComments = useStreamForFlushingComments;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        return this.broadcasterFactory;
    }

    public AtmosphereServlet setBroadcasterFactory(BroadcasterFactory broadcasterFactory) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.broadcasterFactory = broadcasterFactory;
        this.configureBroadcaster(this.config.getServletContext());
        return this;
    }

    public String getBroadcasterCacheClassName() {
        return broadcasterCacheClassName;
    }

    public void setBroadcasterCacheClassName(String broadcasterCacheClassName) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        AtmosphereServlet.broadcasterCacheClassName = broadcasterCacheClassName;
        this.configureBroadcaster(this.config.getServletContext());
    }

    public void addBroadcasterType(String broadcasterTypeString) {
        this.broadcasterTypes.add(broadcasterTypeString);
    }

    public String getWebSocketProtocolClassName() {
        return this.webSocketProtocolClassName;
    }

    public void setWebSocketProtocolClassName(String webSocketProtocolClassName) {
        this.webSocketProtocolClassName = webSocketProtocolClassName;
    }

    protected Map<String, String> configureQueryStringAsRequest(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            headers.put(s, request.getParameter(s));
        }
        return headers;
    }

    protected boolean isIECandidate(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        if (userAgent.contains("MSIE") || userAgent.contains(".NET")) {
            String transport = request.getHeader("X-Atmosphere-Transport");
            return transport == null;
        }
        return false;
    }

    public WebSocketProtocol getWebSocketProtocol() {
        return this.webSocketProtocol;
    }

    public org.eclipse.jetty.websocket.WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        logger.debug("WebSocket upgrade requested");
        request.setAttribute(WebSocket.WEBSOCKET_INITIATED, (Object)true);
        return new JettyWebSocketHandler(request, this, this.webSocketProtocol);
    }

    public static class Action {
        public long timeout = -1L;
        public TYPE type;

        public Action() {
            this.type = TYPE.CREATED;
        }

        public Action(TYPE type) {
            this.type = type;
        }

        public Action(TYPE type, long timeout) {
            this.timeout = timeout;
            this.type = type;
        }

        public static enum TYPE {
            SUSPEND,
            RESUME,
            TIMEOUT,
            CANCELLED,
            KEEP_ALIVED,
            CREATED;

        }
    }

    public class AtmosphereConfig {
        private boolean supportSession = true;
        private BroadcasterFactory broadcasterFactory;
        private String dispatcherName = "default";
        private Map<String, Object> properties = new HashMap<String, Object>();

        protected Map<String, AtmosphereHandlerWrapper> handlers() {
            return AtmosphereServlet.this.atmosphereHandlers;
        }

        public ServletContext getServletContext() {
            return AtmosphereServlet.this.getServletContext();
        }

        public String getDispatcherName() {
            return this.dispatcherName;
        }

        public void setDispatcherName(String dispatcherName) {
            this.dispatcherName = dispatcherName;
        }

        public String getInitParameter(String name) {
            String s = (String)AtmosphereServlet.this.initParams.get(name);
            if (s != null) {
                return s;
            }
            return AtmosphereServlet.this.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return AtmosphereServlet.this.getInitParameterNames();
        }

        public ServletConfig getServletConfig() {
            return AtmosphereServlet.this.getServletConfig();
        }

        public String getWebServerName() {
            return AtmosphereServlet.this.cometSupport.getContainerName();
        }

        public BroadcasterFactory getBroadcasterFactory() {
            return this.broadcasterFactory;
        }

        public boolean isSupportSession() {
            return this.supportSession;
        }

        public void setSupportSession(boolean supportSession) {
            this.supportSession = supportSession;
        }

        public AtmosphereServlet getServlet() {
            return AtmosphereServlet.this;
        }

        public Map<String, Object> properties() {
            return this.properties;
        }
    }

    public static final class AtmosphereHandlerWrapper {
        public final AtmosphereHandler atmosphereHandler;
        public Broadcaster broadcaster;
        public String mapping;

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler, String mapping) {
            this.atmosphereHandler = atmosphereHandler;
            try {
                if (BroadcasterFactory.getDefault() != null) {
                    this.broadcaster = BroadcasterFactory.getDefault().get(mapping);
                } else {
                    this.mapping = mapping;
                }
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler, Broadcaster broadcaster) {
            this.atmosphereHandler = atmosphereHandler;
            this.broadcaster = broadcaster;
        }

        public String toString() {
            return "AtmosphereHandlerWrapper{ atmosphereHandler=" + this.atmosphereHandler + ", broadcaster=" + this.broadcaster + " }";
        }
    }
}

