/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncProtocol;

public class AtmosphereResponse<A extends AsyncIOWriter>
extends HttpServletResponseWrapper {
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final A asyncIOWriter;
    private int status = 200;
    private String statusMessage = "";
    private String charSet = "UTF-8";
    private long contentLength = -1L;
    private String contentType = "txt/html";
    private boolean isCommited = false;
    private Locale locale;
    private final AsyncProtocol asyncProtocol;
    private boolean headerHandled = false;
    private final HttpServletRequest atmosphereRequest;
    private static final DummyHttpServletResponse dsr = new DummyHttpServletResponse();

    public AtmosphereResponse(A asyncIOWriter, AsyncProtocol asyncProtocol, HttpServletRequest atmosphereRequest) {
        super((HttpServletResponse)dsr);
        this.asyncIOWriter = asyncIOWriter;
        this.asyncProtocol = asyncProtocol;
        this.atmosphereRequest = atmosphereRequest;
    }

    public AtmosphereResponse(HttpServletResponse r, A asyncIOWriter, AsyncProtocol asyncProtocol, HttpServletRequest atmosphereRequest) {
        super(r);
        this.asyncIOWriter = asyncIOWriter;
        this.asyncProtocol = asyncProtocol;
        this.atmosphereRequest = atmosphereRequest;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.get(name) != null;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc, msg);
        this.asyncIOWriter.writeError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.setStatus(sc);
        this.asyncIOWriter.writeError(sc, "");
    }

    public void sendRedirect(String location) throws IOException {
        this.asyncIOWriter.redirect(location);
    }

    public void setDateHeader(String name, long date) {
        this.headers.put(name, String.valueOf(date));
    }

    public void addDateHeader(String name, long date) {
        this.headers.put(name, String.valueOf(date));
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String statusMessage) {
        this.statusMessage = statusMessage;
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Map<String, String> headers() {
        if (!this.headerHandled) {
            for (Cookie c : this.cookies) {
                this.headers.put("Set-Cookie", c.toString());
            }
            this.headerHandled = false;
        }
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> s = new ArrayList<String>();
        s.add(this.headers.get(name));
        return Collections.unmodifiableList(s);
    }

    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    public void setCharacterEncoding(String charset) {
        this.charSet = this.charSet;
    }

    public String getCharacterEncoding() {
        return this.charSet;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void write(int i) throws IOException {
                if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                    AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new byte[]{(byte)i}, 0, 1));
                } else {
                    AtmosphereResponse.this.asyncIOWriter.write(new byte[]{(byte)i});
                }
            }

            public void write(byte[] bytes) throws IOException {
                if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                    AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, bytes, 0, bytes.length));
                } else {
                    AtmosphereResponse.this.asyncIOWriter.write(bytes);
                }
            }

            public void write(byte[] bytes, int start, int offset) throws IOException {
                if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                    byte[] b = AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, bytes, start, offset);
                    AtmosphereResponse.this.asyncIOWriter.write(b, 0, b.length);
                } else {
                    AtmosphereResponse.this.asyncIOWriter.write(bytes, start, offset);
                }
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter((OutputStream)this.getOutputStream()){

            @Override
            public void write(char[] chars, int offset, int lenght) {
                try {
                    if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new String(chars, offset, lenght)));
                    } else {
                        AtmosphereResponse.this.asyncIOWriter.write(new String(chars, offset, lenght));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void write(char[] chars) {
                try {
                    if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new String(chars)));
                    } else {
                        AtmosphereResponse.this.asyncIOWriter.write(new String(chars));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void write(String s, int offset, int lenght) {
                try {
                    if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new String(s.substring(offset, lenght))));
                    } else {
                        AtmosphereResponse.this.asyncIOWriter.write(new String(s.substring(offset, lenght)));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void write(String s) {
                try {
                    if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new String(s)));
                    } else {
                        AtmosphereResponse.this.asyncIOWriter.write(new String(s));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isCommitted() {
        return this.isCommited;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isWrapperFor(ServletResponse wrapped) {
        return false;
    }

    public boolean isWrapperFor(Class wrappedType) {
        return false;
    }

    public A getasyncIOWriter() {
        return this.asyncIOWriter;
    }

    public HttpServletRequest getRequest() {
        return this.atmosphereRequest;
    }

    private static final class DummyHttpServletResponse
    implements HttpServletResponse {
        private DummyHttpServletResponse() {
        }

        public void addCookie(Cookie cookie) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }

        public void setDateHeader(String name, long date) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
        }

        public void addHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public void setStatus(int sc) {
        }

        public void setStatus(int sc, String sm) {
        }

        public int getStatus() {
            return 0;
        }

        public String getHeader(String name) {
            return null;
        }

        public Collection<String> getHeaders(String name) {
            return null;
        }

        public Collection<String> getHeaderNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            return null;
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentType(String type) {
        }

        public void setBufferSize(int size) {
        }

        public int getBufferSize() {
            return 0;
        }

        public void flushBuffer() throws IOException {
        }

        public void resetBuffer() {
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void setLocale(Locale loc) {
        }

        public Locale getLocale() {
            return null;
        }
    }
}

