/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.container;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocket;

public class JettyWebSocket
implements WebSocket {
    private final WebSocket.Outbound outbound;
    private AtomicBoolean webSocketLatencyCheck = new AtomicBoolean(false);

    public JettyWebSocket(WebSocket.Outbound outbound) {
        this.outbound = outbound;
    }

    @Override
    public void writeError(int errorCode, String message) throws IOException {
    }

    @Override
    public void redirect(String location) throws IOException {
    }

    @Override
    public void write(byte frame, String data) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection closed");
        }
        this.outbound.sendMessage(frame, data);
    }

    @Override
    public void write(byte frame, byte[] data) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection closed");
        }
        this.outbound.sendMessage(frame, data, 0, data.length);
    }

    @Override
    public void write(byte frame, byte[] data, int offset, int length) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection closed");
        }
        this.outbound.sendMessage(frame, data, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.outbound.disconnect();
    }
}

