/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.container;

import java.io.IOException;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty8WebSocket
implements WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(Jetty8WebSocket.class);
    private final WebSocket.Connection connection;

    public Jetty8WebSocket(WebSocket.Connection connection) {
        this.connection = connection;
    }

    @Override
    public void writeError(int errorCode, String message) throws IOException {
    }

    @Override
    public void redirect(String location) throws IOException {
    }

    @Override
    public void write(byte frame, String data) throws IOException {
        if (!this.connection.isOpen()) {
            throw new IOException("Connection closed");
        }
        logger.debug("WebSocket.write()");
        this.connection.sendMessage(data);
    }

    @Override
    public void write(byte frame, byte[] data) throws IOException {
        if (!this.connection.isOpen()) {
            throw new IOException("Connection closed");
        }
        logger.debug("WebSocket.write()");
        this.connection.sendMessage(data, 0, data.length);
    }

    @Override
    public void write(byte frame, byte[] data, int offset, int length) throws IOException {
        if (!this.connection.isOpen()) {
            throw new IOException("Connection closed");
        }
        logger.debug("WebSocket.write()");
        this.connection.sendMessage(new String(data, offset, length, "UTF-8"));
    }

    @Override
    public void close() throws IOException {
        logger.debug("WebSocket.close()");
        this.connection.disconnect();
    }
}

