/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketProcessor
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketProcessor.class);
    private final AtmosphereServlet atmosphereServlet;
    private final WebSocket webSocket;
    private final AtomicBoolean loggedMsg = new AtomicBoolean(false);
    private AtmosphereResource<HttpServletRequest, HttpServletResponse> resource;
    private AtmosphereHandler handler;

    public WebSocketProcessor(AtmosphereServlet atmosphereServlet, WebSocket webSocket) {
        this.webSocket = webSocket;
        this.atmosphereServlet = atmosphereServlet;
    }

    public final void dispatch(HttpServletRequest request) throws IOException {
        if (!this.loggedMsg.getAndSet(true)) {
            logger.info("Atmosphere detected WebSocket: {}", (Object)this.webSocket.getClass().getName());
        }
        WebSocketHttpServletResponse<WebSocket> wsr = new WebSocketHttpServletResponse<WebSocket>(this.webSocket);
        AtmosphereRequest r = new AtmosphereRequest.Builder().request(request).headers(this.configureHeader(request)).build();
        request.setAttribute(WebSocket.WEBSOCKET_SUSPEND, (Object)true);
        this.dispatch((HttpServletRequest)r, (HttpServletResponse)wsr);
        this.resource = (AtmosphereResource)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        this.handler = (AtmosphereHandler)request.getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER);
        if (this.resource == null || !this.resource.getAtmosphereResourceEvent().isSuspended()) {
            logger.error("No AtmosphereResource has been suspended. The WebSocket will be closed.");
            this.webSocket.close();
        }
    }

    protected final void dispatch(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.atmosphereServlet.doCometSupport(request, response);
        }
        catch (IOException e) {
            logger.info("failed invoking atmosphere servlet doCometSupport()", (Throwable)e);
        }
        catch (ServletException e) {
            logger.info("failed invoking atmosphere servlet doCometSupport()", (Throwable)e);
        }
    }

    public AtmosphereResource<HttpServletRequest, HttpServletResponse> resource() {
        if (this.resource == null) {
            throw new IllegalStateException("No AtmosphereResource has been suspended.");
        }
        return this.resource;
    }

    public HttpServletRequest request() {
        return this.resource().getRequest();
    }

    public WebSocket webSocketSupport() {
        return this.webSocket;
    }

    public abstract void parseMessage(String var1);

    public abstract void parseMessage(byte[] var1, int var2, int var3);

    public void close() {
        try {
            if (this.handler != null && this.resource != null) {
                this.handler.onStateChange(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)this.resource, false, true));
            }
        }
        catch (IOException e) {
            if (AtmosphereResourceImpl.class.isAssignableFrom(this.resource.getClass())) {
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(this.resource)).onThrowable(e);
            }
            logger.info("Failed invoking atmosphere handler onStateChange()", (Throwable)e);
        }
        if (this.resource != null) {
            this.resource.getBroadcaster().removeAtmosphereResource(this.resource);
        }
    }

    public String toString() {
        return "WebSocketProcessor{ handler=" + this.handler + ", resource=" + this.resource + ", webSocket=" + this.webSocket + " }";
    }

    public void notifyListener(WebSocketEventListener.WebSocketEvent event) {
        if (this.resource == null) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(this.resource);
        for (AtmosphereResourceEventListener l : r.atmosphereResourceEventListener()) {
            if (!WebSocketEventListener.class.isAssignableFrom(l.getClass())) continue;
            switch (event.type()) {
                case CONNECT: {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onConnect(event);
                    break;
                }
                case DISCONNECT: {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                    break;
                }
                case CONTROL: {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onControl(event);
                    break;
                }
                case MESSAGE: {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onMessage(event);
                    break;
                }
                case HANDSHAKE: {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onHandshake(event);
                    break;
                }
                case CLOSE: {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onClose(event);
                }
            }
        }
    }

    protected Map<String, String> configureHeader(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            headers.put(s, request.getParameter(s));
        }
        headers.put("X-Atmosphere-Transport", "websocket");
        return headers;
    }
}

