/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;

public class AtmosphereResourceEventImpl
implements AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> {
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final AtomicBoolean isResumedOnTimeout = new AtomicBoolean(false);
    private Throwable throwable;
    protected Object message;
    protected final AtmosphereResourceImpl resource;

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource) {
        this.resource = resource;
        this.throwable = null;
    }

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource, boolean isCancelled, boolean isResumedOnTimeout) {
        this.isCancelled.set(isCancelled);
        this.isResumedOnTimeout.set(isResumedOnTimeout);
        this.resource = resource;
        this.throwable = null;
    }

    public AtmosphereResourceEventImpl(AtmosphereResourceImpl resource, boolean isCancelled, boolean isResumedOnTimeout, Throwable throwable) {
        this.isCancelled.set(isCancelled);
        this.isResumedOnTimeout.set(isResumedOnTimeout);
        this.resource = resource;
        this.throwable = throwable;
    }

    @Override
    public boolean isResuming() {
        return this.resource.action().type == AtmosphereServlet.Action.TYPE.RESUME;
    }

    @Override
    public boolean isSuspended() {
        return this.resource.action().type == AtmosphereServlet.Action.TYPE.SUSPEND;
    }

    @Override
    public Object getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(Object message) {
        this.message = message;
    }

    @Override
    public boolean isResumedOnTimeout() {
        return this.isResumedOnTimeout.get();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    protected void setCancelled(boolean isCancelled) {
        this.isCancelled.set(isCancelled);
    }

    protected void setIsResumedOnTimeout(boolean isResumedOnTimeout) {
        this.isResumedOnTimeout.set(isResumedOnTimeout);
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    @Override
    public AtmosphereResource<HttpServletRequest, HttpServletResponse> getResource() {
        return this.resource;
    }

    @Override
    public void write(OutputStream os, Object o) throws IOException {
        this.resource.write(os, o);
    }

    public void setThrowable(Throwable t) {
        this.throwable = this.throwable;
    }

    public String toString() {
        return "AtmosphereResourceEventImpl{isResuming=" + this.isResuming() + " isCancelled=" + this.isCancelled + ", isResumedOnTimeout=" + this.isResumedOnTimeout + ", message=" + this.message + ", resource=" + this.resource + ", throwable=" + this.throwable + '}';
    }
}

